print("Initializing Lua")

startDirectory = intruder.GetCurrentWorkingDirectory()

-- Move elements from intruder name to global namespace
GSurface = intruder.GSurface
GCoord = intruder.GCoord
GPoint = intruder.GPoint
GColor = intruder.GColor
GColorFromHSV = intruder.GColorFromHSV
GRect = intruder.GRect
GGradient = intruder.GGradient

kGAlignLeft = intruder.kGAlignLeft
kGAlignCenter = intruder.kGAlignCenter
kGAlignRight = intruder.kGAlignRight
kGVerticalAlignTop = intruder.kGVerticalAlignTop
kGVerticalAlignCenter = intruder.kGVerticalAlignCenter
kGVerticalAlignBottom = intruder.kGVerticalAlignBottom

kGEventNone = intruder.kGEventNone
kGEventMouseDown = intruder.kGEventMouseDown
kGEventMouseUp = intruder.kGEventMouseUp
kGEventMouseMoved = intruder.kGEventMouseMoved
kGEventKeyDown = intruder.kGEventKeyDown
kGEventKeyUp = intruder.kGEventKeyUp
kGEventRedraw = intruder.kGEventRedraw
kGEventTextEditFinished = intruder.kGEventTextEditFinished
kGEventResize = intruder.kGEventResize
kGEventMouseWheel = intruder.kGEventMouseWheel

kGEventMouseButtonNone = intruder.kGEventMouseButtonNone
kGEventMouseButtonLeft = intruder.kGEventMouseButtonLeft
kGEventMouseButtonRight = intruder.kGEventMouseButtonRight

kGEventModifierControl = intruder.kGEventModifierControl
kGEventModifierShift = intruder.kGEventModifierShift
kGEventModifierAlt = intruder.kGEventModifierAlt


-- Utility functions
function clamp(value, min, max)
	if (value < min) then
		return min
	elseif (value > max) then
		return max
	else
		return value
	end
end


-- Memory management
--[[
	Lua generally has a very well-functioning garbage collector. 
	There is one issue though: integration with C/C++.
	If we create an instance of a C++ class in Lua (trough the SWIG
	interface), and then hand it off to C++ without having any Lua
	references to the instance, the object will be garbage collected,
	even though C++ may still have a reference to it.
	For this reason a simple reference counting system is implemented 
	for objects we create in Lua but hand of to C++.
	
	NOTE: The system doesn't actually do any reference counting (it 
	just keeps object around forever), but can be improved at a later
	date)
]]

uncollectables = {}

function retain(object)
	table.insert(uncollectables, object) -- keep object around forever
	return object
end

function release(object)
	-- don't do anything
	-- TODO
end


-- Load other Lua scripts
dofile("gui/script/root.lua")
dofile("gui/script/util.lua")
dofile("gui/script/loadsave.lua")
dofile("gui/script/postprocessparameters.lua")
dofile("gui/script/controls/control.lua")
dofile("gui/script/controls/framelayout.lua")
dofile("gui/script/controls/button.lua")
dofile("gui/script/controls/pagelist.lua")
dofile("gui/script/controls/scrollbar.lua")
dofile("gui/script/controls/scrollview.lua")
dofile("gui/script/controls/nodegrid.lua")
dofile("gui/script/controls/parameterlist.lua")
dofile("gui/script/controls/contextmenu.lua")
dofile("gui/script/controls/contextmenuex.lua")
dofile("gui/script/controls/parameters/scalarparameter.lua")
dofile("gui/script/controls/parameters/stringparameter.lua")
dofile("gui/script/controls/parameters/optionmenuparameter.lua")
dofile("gui/script/controls/parameters/fileparameter.lua")
dofile("gui/script/controls/parameters/assetparameter.lua")
dofile("gui/script/controls/parameters/vectorparameter.lua")
dofile("gui/script/controls/parameters/editablestringparameter.lua")
dofile("gui/script/sanitizestring.lua")


-- Change equality comparison function for ZNode
nodeMetaTable = getmetatable(intruder.ZNode(nil, 0, 0, 0, 0)) -- maybe there is a better way of getting the metatable? couldn't figure it out (ralph)
nodeMetaTable.__eq = swig_equals


-- Create global objects
g_window = intruder.GWindow()

-- Create and initialize root
root = Root.Create(g_window, g_pGraph)


-- Functions for events and drawing
function HandleEvent(event)
	-- Set normal cursor
	root.window:SetCursor(intruder.GWindow_kGCursorNormal)
	
	-- Handle Event
	root:HandleEvent(event)
	
	-- Tell window to actually update cursor
	root.window:UpdateCursor()
	
	-- Do a garbage collection run
	collectgarbage()
end

function Draw()
	-- Redraw
	root:Draw()
	
	-- Do a garbage collection run
	collectgarbage()
end

function CurrentEditableStringUpdated()
	EditableStringParameter.currentOnChange()	
end