#version 150 core

out vec4 fragColor;

uniform sampler2D tile;
uniform sampler2D background;
uniform vec2 screen;

in vec4 color;
in vec2 uv;
in float fade;

float getDepth()
{
    float z = gl_FragCoord.z;
    float n = 0.1;
    float f = 500;
    float depth = (2.0 * n) / (f + n - z * (f - n));
    return 1.0 - depth;
}

void main()
{
    vec4 col;
    if(color.g > 0.95)
    {
        col = texture(tile, uv) * vec4(1.0);
    }
    else
    {
        col = texture(tile, uv) * vec4(0.25, 0.25, 0.25, 1.0);
    }
    
    vec4 bg = texture(background, gl_FragCoord.xy / screen);
    float depth = getDepth();
    fragColor = mix(bg, col * depth, fade);
}