
vec3 calculate_gauss_model(in vec3 n, in vec3 l, in vec3 e, in float shininess)
{
	vec3 hv = normalize(l + e);
	float NdotL = dot(n, l);
	float diffTerm = max(NdotL, 0.0);
	float NdotHV = dot(n, hv);
	float specTerm = exp( -pow(acos(NdotHV) / shininess, 2.0) ) * NdotL;
	return vec3(diffTerm, specTerm, 1.0);
}


