#version 330 core

uniform sampler2D volume;
uniform sampler2D shape;
uniform sampler2D normal_depth;
uniform sampler2D shadowmap;
uniform vec2 viewport;

uniform mat4 ShadowMatrix;
//uniform mat4 TextureMatrix;

in vec3 uv_shade;
in vec3 wpos;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

float calculate_shadow(in vec4 pos)
{
	const float samples = 3.0;
	const float filterWidth = samples / 1024.0;
	const float stepSize = 2.0*filterWidth / samples;
	float count = 0.0;

	for (float i=-filterWidth; i < filterWidth; i+=stepSize)
	{
		for (float j=-filterWidth; j < filterWidth; j+=stepSize)
		{
			count += float(pos.z < texture(shadowmap, pos.xy + vec2(i,j)).x);
		}
	}
	return (count / (samples*samples));//*0.75 + 0.25;
}

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	//vec4 tpos = TextureMatrix * vec4(pos, 1.0);
	vec4 tpos = ShadowMatrix * vec4(wpos, 1.0);
	tpos /= tpos.w;
	float shadow_term = calculate_shadow(tpos);

	float alpha = min(0.25, clamp((wpos.z - pos.z)*(1.0/8.0), 0.0, 1.0)) * shadow_term;

	frag_color = texture(volume, uv_shade.xy) * texture(shape, uv_shade.xy) * uv_shade.z * alpha;
	frag_color.a = 0.0;
}
