; Set all 8 values to zero
; if you want all sounds at full volume.  10 is probably 
; about the highest amount of attenuation you'll want.
;
; 000=square  001=bass  010=pitfall  011=noise
; 100=buzz    101=lead  110=saw      111=engine
soundVolArray
	byte 10,10,6,7,7,10,4,10

; Default Sound Type Setup:
; 000 0 Square  = 4
; 001 1 Bass    = 6
; 010 2 Pitfall = 7
; 011 3 Noise   = 8
;
; 100 4 Buzz    = 15
; 101 5 Lead    = 12
; 110 6 Saw     = 1
; 111 7 Engine  = 3
;
soundTypeArray
    byte 4,6,7,8
    byte 15,12,1,3

HATVOLUME equ 4
HATPITCH  equ 0
HATSOUND  equ 8
HATSTATIC equ 1         ;if non-zero, use static hat pattern (saves 5 B)
HATPATTRN equ %10001000 ;if HATSTATIC

#if !HATSTATIC
hatPattern
    byte %10001000
    byte %10001000
    byte %10001000
    byte %10001000
#endif

    MAC MEASURES        ;saves 3 B in player by premultiplying by eight
    byte {1}*6,{2}*6,{3}*6,{4}*6
    ENDM
song1   ;hi-hat always runs in this channel. having it non-configurable saves ROM
    byte 0              ;black, intro text - whatever.
    MEASURES 0, 0, 0, 0
    MEASURES 0, 0, 0, 0

    MEASURES 3, 0, 3, 0
    MEASURES 4, 0, 4, 0
    MEASURES 3, 3, 3, 3
    MEASURES 4, 0, 4, 0

    MEASURES 3, 3, 3, 3
    MEASURES 4, 4, 4, 4
    MEASURES 3, 3, 3, 3
    MEASURES 4, 4, 4, 4

INTROLENGTH equ *-song1
    MEASURES 5, 5, 5, 5
    MEASURES 6, 6, 6, 6
    MEASURES 5, 5, 5, 5
    MEASURES 6, 6, 6, 6

    MEASURES 9, 9, 9, 9
    MEASURES 10,10,10,10
    MEASURES 9, 9, 9, 9
    MEASURES 10,10,10,10

SONGEND     equ *-song1
HATSTART    equ *-song1     ;saves 6 B if == 0 (@ song1)

song2
    byte 0
    MEASURES 1, 1, 1, 1
    MEASURES 2, 2, 2, 2

    MEASURES 1, 1, 1, 1
    MEASURES 2, 2, 2, 2
    MEASURES 1, 1, 1, 1
    MEASURES 2, 2, 2, 2

    MEASURES 7, 7, 7, 7
    MEASURES 8, 8, 8, 8
    MEASURES 7, 7, 7, 7
    MEASURES 8, 8, 8, 8

    MEASURES 7, 7, 7, 7
    MEASURES 8, 8, 8, 8
    MEASURES 7, 7, 7, 7
    MEASURES 8, 8, 8, 8

    MEASURES 7, 7, 7, 7
    MEASURES 8, 8, 8, 8
    MEASURES 7, 7, 7, 7
    MEASURES 8, 8, 8, 8

patternArray    ; starts at 1
    word BeatBass0,BeatBass1,BeatBass2
    word BeatBass3,BeatBass4,BeatBass5
    word HoldG2,0,SinTab
    word HoldE2,0,SinTab+26
    word BeatG2B2,BeatG2B22,SinTab+3
    word BeatE2G2,BeatE2G22,SinTab+24
    word BeatBass0,BeatBass1Alt,BeatBass2
    word BeatBass3,BeatBass4Alt,BeatBass5
    word BeatG2B2,BeatG2B22,Fiddle0
    word BeatE2G2,BeatE2G22,Fiddle1

BeatBass0
    byte %01010011,%01010011,%01010011,%01010011
    byte %01010011,%01010011,%01001001,%01001001
    byte %11110011
BeatBass1
    byte %01001001,%01001001,%01001001,%01001001
    byte %01001001,%01001001,%01001001,%01001001
    byte %01100000
BeatBass1Alt
    byte %01001001,%01001001,%01001001
    byte %10000101,%10000110,%10000111,%10000111,%10000111
    byte %01111000
BeatBass2
    byte %01001001,%01001001,%01001001,%01001001
    byte %01001001,%01001001,%01001001,%01001001
    byte %00110110

BeatBass3
    byte %01010111,%01010111,%01010111,%01010111
    byte %01010111,%01010111,%01001011,%01001011
    byte %11110011
BeatBass4
    byte %01001011,%01001011,%01001011,%01001011
    byte %01001011,%01001011,%01001011,%01001011
    byte %01100000
BeatBass4Alt
    byte %01001011,%01001011,%01001011
    byte %11100101,%11100110,%11100111,%11100111,%11100111
    byte %01111000
BeatBass5
    byte %01001011,%01001011,%01001011,%01001011
    byte %01001011,%01001011,%01001011,%01001011
    byte %00110110

BeatG2B2
    byte %00101001,%00101001,%00101001,%00100111
    byte %00100111,%00100111,%00100101,%00100101
    byte %11011011
BeatG2B22
    byte %00100101,%00100100,%00100100,%00100100
    byte %00100100,%00100100,%00100100,%00100100
    byte %01111000

BeatE2G2
    byte %00101011,%00101011,%00101011,%00101001
    byte %00101001,%00101001,%00100111,%00100111
    byte %11011011
BeatE2G22
    byte %00100111,%00100101,%00100101,%00100101
    byte %00100101,%00100101,%00100101,%00100101
    byte %01111000

HoldG2
    byte %00101001,%00101001,%00101001,%00101001
    byte %00101001,%00101001,%00101001,%00101001
    byte %11110000
HoldE2
    byte %00101011,%00101011,%00101011,%00101011
    byte %00101011,%00101011,%00101011,%00101011
    byte %11110000

Fiddle0
    byte %01000101,%01000011,47,49  ;sintab+3
    byte 52,54,56,58
    byte %11101000

Fiddle1
    byte %01000111,%01000100,%01000011,%01000100
    byte 44,41,38,35
    byte %11101111
