#ifndef EDVIEW_H
#define EDVIEW_H

#include <QtOpenGL>
#include <QImage>
#include "dmengine.h"


class QEDGLDemoView : public QGLWidget
{
    Q_OBJECT

public:
    QEDGLDemoView(QWidget *parent);
    ~QEDGLDemoView();

    QSize minimumSizeHint() const;
    QSize sizeHint() const;

    virtual void setEngineData(DMEngineData *mengine);
    virtual void render(int frameTime);
    void paintEvent(QPaintEvent *);

private:
    void saveGLState();
    void restoreGLState();

protected:
    DMEngineData *engine;
};


class QEDSWDemoView : public QEDGLDemoView
{
    Q_OBJECT

public:
    QEDSWDemoView(QWidget *parent);
    ~QEDSWDemoView();

    void setEngineData(DMEngineData *mengine);
    void render(int frameTime);
    void paintEvent(QPaintEvent *);

private:
    QImage *img;
};


#endif
