//
// Demo Editor -- Timeline state object
// Wrapper class for DMTimeline data
// (C) Copyright 2012 Matti 'ccr' Hmlinen <ccr@tnsp.org>
//
#ifndef EDTIMELINEOBJECT_H
#define EDTIMELINEOBJECT_H

#include "dmengine.h"
#include <QString>

class EDTimelineObject
{
private:
    QString cstate;
    int ntouches;

public:
    QString filename;
    DMTimeline *tl;

    EDTimelineObject();
    EDTimelineObject(EDTimelineObject *);
    ~EDTimelineObject();

    int load(QString filename);
    int save(QString filename);
    
    void scrub();
    void touch();
    bool touched();

    void setState(const QString &mstate);
    QString state() const;
};


#endif
