/*
 * DMLib
 * -- Unscaled sprite / surface blitting function template
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2012 Tecnic Software productions (TNSP)
 */

int DM_BLITFUNC_NAME (SDL_Surface *src,
    const int x0, const int y0,
    SDL_Surface *dst
#ifdef DM_BLITFUNC_ARGS
    DM_BLITFUNC_ARGS
#endif
    )
#ifdef DM_HEADER
;
#else
{
    int yc;
    DMQValue xr, yr;
#ifdef DM_BLITFUNC_VARS
    DM_BLITFUNC_VARS
#endif
    
    // Clip coordinates
    if (dmUnscaledClipCoord(&xr, x0, src->w,
        dst->clip_rect.x, dst->clip_rect.x + dst->clip_rect.w)
        ||
        dmUnscaledClipCoord(&yr, y0, src->h,
        dst->clip_rect.y, dst->clip_rect.y + dst->clip_rect.h))
        return -1;

#ifdef DM_BLITFUNC_INIT
    DM_BLITFUNC_INIT
#endif
    const int srcadd = src->pitch / DM_BLITFUNC_SRC_BYTES;
    const int dstadd = xr.vadd - dst->clip_rect.w + dst->clip_rect.x + (dst->pitch / DM_BLITFUNC_DST_BYTES);

    DM_BLITFUNC_SRC_TYPE * sp = ((DM_BLITFUNC_SRC_TYPE *) src->pixels) + (yr.voffs * src->pitch) / DM_BLITFUNC_SRC_BYTES;
    DM_BLITFUNC_DST_TYPE * dp = ((DM_BLITFUNC_DST_TYPE *) dst->pixels) + (yr.v0 * dst->pitch) / DM_BLITFUNC_DST_BYTES + xr.v0;

    for (yc = yr.v0; yc < yr.v1; yc++)
    {
        int xv, xc;

#ifdef DM_BLITFUNC_INNER_INIT
        DM_BLITFUNC_INNER_INIT
#endif

        for (xv = xr.voffs, xc = xr.v0; xc < xr.v1; xc++, xv++)
        {
            DM_BLITFUNC_INNER
        }
        sp += srcadd;
        dp += dstadd;
    }

#ifdef DM_BLITFUNC_FINISH
    DM_BLITFUNC_FINISH
#endif
    return 0;
}
#endif


#undef DM_BLITFUNC_NAME
#undef DM_BLITFUNC_ARGS
#undef DM_BLITFUNC_SRC_BYTES
#undef DM_BLITFUNC_DST_BYTES
#undef DM_BLITFUNC_SRC_TYPE
#undef DM_BLITFUNC_DST_TYPE
#undef DM_BLITFUNC_VARS
#undef DM_BLITFUNC_INIT
#undef DM_BLITFUNC_INNER_INIT
#undef DM_BLITFUNC_INNER
#undef DM_BLITFUNC_FINISH
