/*
 * DMLib
 * -- Bitmap and TTF text & font support
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2012 Tecnic Software productions (TNSP)
 */
#include "dmtext.h"


void dmDrawTTFTextConst(SDL_Surface *screen, TTF_Font *font, SDL_Color col, int xc, int yc, const char *fmt)
{
    SDL_Surface *text = TTF_RenderText_Blended(font, fmt, col);
    if (text)
    {
        SDL_Rect rect;
        rect.x = xc;
        rect.y = yc;
        rect.w = text->w;
        rect.h = text->h;
        SDL_BlitSurface(text, NULL, screen, &rect);
        SDL_FreeSurface(text);
    }
}

void dmDrawTTFTextVA(SDL_Surface *screen, TTF_Font *font, SDL_Color col, int xc, int yc, const char *fmt, va_list ap)
{
    char *tmp = dm_strdup_vprintf(fmt, ap);
    if (tmp != NULL)
    {
        dmDrawTTFTextConst(screen, font, col, xc, yc, tmp);
        dmFree(tmp);
    }
}

void dmDrawTTFText(SDL_Surface *screen, TTF_Font *font, SDL_Color col, int xc, int yc, const char *fmt, ...)
{
    va_list ap;
    
    va_start(ap, fmt);
    dmDrawTTFTextVA(screen, font, col, xc, yc, fmt, ap);
    va_end(ap);
}
