/*
 * DMLib
 * -- Bitmap font support
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2012 Tecnic Software productions (TNSP)
 */
#ifndef DMFONT_H
#define DMFONT_H

#include "dmlib.h"
#include "dmres.h"

#ifdef DM_GFX_TTF_TEXT
#include <SDL_ttf.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Bitmapped fonts and text
 */
#ifdef DM_GFX_BM_TEXT

// DMFONT format constants
#define DMFONT_MAGIC         "DMFONT"
#define DMFONT_VERSION       0x0100

#define DMFONT_MIN_WIDTH     3
#define DMFONT_MIN_HEIGHT    3
#define DMFONT_MAX_WIDTH     128
#define DMFONT_MAX_HEIGHT    128
#define DMFONT_MAX_GLYPHS    1024

#define DMFONT_NPALETTE      256

// Legacy TSFONT loading support
#define TSFONT_MAGIC         "TSFONT"
#define TSFONT_VERSION       0x0205


typedef struct
{
    int width, height;     // Dimensions
    int nglyphs;           // Size of glyphs array
    SDL_Surface **glyphs;  // NOTE! Not all glyphs may be allocated
} DMBitmapFont;


DMBitmapFont *dmNewBitmapFont(int nglyphs, int width, int height);
int dmFreeBitmapFont(DMBitmapFont *font);
int dmLoadBitmapFont(DMResource *res, DMBitmapFont **pfont);
int dmSaveBitmapFont(DMResource *res, DMBitmapFont *font);
int dmSetBitmapFontPalette(DMBitmapFont *font, SDL_Color *pal, int start, int size);

void dmDrawBMTextConst(SDL_Surface *screen, DMBitmapFont *font, BOOL condensed, int mode, int xc, int yc, const char *str);
void dmDrawBMTextVA(SDL_Surface *screen, DMBitmapFont *font, BOOL condensed, int mode, int xc, int yc, const char *fmt, va_list ap);
void dmDrawBMText(SDL_Surface *screen, DMBitmapFont *font, BOOL condensed, int mode, int xc, int yc, const char *fmt, ...);


static inline SDL_Surface *dmGetBMGlyph(DMBitmapFont *font, int ch)
{
    if (ch < 0 || ch >= font->nglyphs || ch == '\n' || ch == '\r')
        ch = 32;

    return font->glyphs[ch];
}
#endif


/* TTF text drawing
 */
#ifdef DM_GFX_TTF_TEXT
void dmDrawTTFTextConst(SDL_Surface *screen, TTF_Font *font, SDL_Color col, int x, int y, const char *fmt);
void dmDrawTTFTextVA(SDL_Surface *screen, TTF_Font *font, SDL_Color col, int x, int y, const char *fmt, va_list ap);
void dmDrawTTFText(SDL_Surface *screen, TTF_Font *font, SDL_Color col, int x, int y, const char *fmt, ...);
#endif


#ifdef __cplusplus
}
#endif

#endif // DMFONT_H
