/*
 * DMLib
 * -- Resource management write helpers
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2011-2012 Tecnic Software productions (TNSP)
 */
#ifndef DMRESW_H
#define DMRESW_H

#include "dmres.h"

#ifdef __cplusplus
extern "C" {
#endif

int          dmf_write_str(DMResource *, void *, size_t);
BOOL         dmf_write_byte(DMResource *, const Uint8);

BOOL         dmf_write_be16(DMResource *, Uint16);
BOOL         dmf_write_be32(DMResource *, Uint32);
BOOL         dmf_write_le16(DMResource *, Uint16);
BOOL         dmf_write_le32(DMResource *, Uint32);

#ifdef DM_HAVE_64BIT
BOOL         dmf_write_be64(DMResource *, Uint64);
BOOL         dmf_write_le64(DMResource *, Uint64);
#endif


#ifdef __cplusplus
}
#endif

#endif // DMRESW_H
