#include "dmlib.h"

void dmLerpInit(DMLerpContext *ctx, DMFloat start, DMFloat end, DMFloat nsteps)
{
    ctx->start = start;
    ctx->end = end;
    ctx->nsteps = nsteps;
}


DMFloat dmCatmullRom(const DMFloat t, const DMFloat p0, const DMFloat p1, const DMFloat p2, const DMFloat p3)
{
    const DMFloat q = t * t;
    return (
        (2 * p1) +
        (-p0 + p2) * t +
        (2 * p0 - 5 * p1 + 4 * p2 - p3) * q +
        (   -p0 + 3 * p1 - 3 * p2 + p3) * q * t
        ) * 0.5f;
}
