#ifndef DMFFT_H
#define DMFFT_H 1

#include "dmlib.h"


typedef double DMFFTType;


typedef struct
{
    int npoints;
    DMFFTType *sinTable;
    int *breversed;
} DMFFTContext;


int   dmInitializeFFT(DMFFTContext *, int);
void  dmEndFFT(DMFFTContext *);
int   dmRealFFT(DMFFTContext *, DMFFTType *);
int   dmConvertFFTtoFreqDomain(DMFFTContext *ctx, DMFFTType *buffer,
      DMFFTType *real, DMFFTType *imag);
int   dmConvertFFTtoFreqAndPower(DMFFTContext *ctx, DMFFTType *buffer,
      DMFFTType *real, DMFFTType *imag, DMFFTType *power, const DMFFTType scale);
int   dmConvertFFTtoPowerAndSum(DMFFTContext *ctx, DMFFTType *buffer,
      DMFFTType *power, const DMFFTType pscale, DMFFTType *sum, const DMFFTType sscale);
int   dmConvertFFTtoTimeDomain(DMFFTContext *ctx, DMFFTType *buffer, DMFFTType *tdom);


#endif // DMFFT_H
