/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

import java.lang.reflect.Method;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import krister.Ess.Ess;

public class AudioOutput {
    protected FadeThread fadeThread;
    protected PanThread panThread;
    protected AudioFormat format;
    protected DataLine.Info info;
    protected SourceDataLine line;
    protected float rVolume;
    protected float rGain;
    protected float rPan;
    protected boolean rMute;
    protected boolean rFading;
    protected boolean rPanning;
    protected byte[] zeroBuffer;
    protected byte[] stereoBuffer;
    protected int rBufferStartTime;
    protected float rSampleRate;
    protected int rState;
    protected EventDispatcher audioOutputFadeED;
    protected EventDispatcher audioOutputPanED;
    protected boolean updateBuffer2;
    public boolean smoothPan;
    public boolean softClip;
    public int bufferStartTime;
    public float[] buffer;
    public float[] buffer2;
    public int duration;
    public int size;
    public float sampleRate;
    public int state;
    public float volume;
    public float gain;
    public float pan;
    public boolean mute;
    public boolean fading;
    public boolean panning;

    public int ms(int n) {
        return (int)((float)n / this.rSampleRate * 1000.0f);
    }

    public int frames(int n) {
        return (int)((float)n * this.rSampleRate / 1000.0f);
    }

    public void volume(float f) {
        this.volume = this.rVolume = f;
        this.gain = this.rGain = (float)(Math.log(f) / Math.log(10.0) * 20.0);
    }

    public void gain(float f) {
        this.gain = this.rGain = f;
        this.volume = this.rVolume = (float)Math.pow(10.0, (double)f / 20.0);
    }

    public void pan(float f) {
        this.pan = this.rPan = Math.min(1.0f, Math.max(-1.0f, f));
    }

    public void mute(boolean bl) {
        this.mute = this.rMute = bl;
    }

    public void fadeTo(float f, int n) {
        this.fadeTo(f, n, 3);
    }

    public void fadeTo(float f, int n, int n2) {
        this.stopFade();
        this.fadeThread.setup(f, n, n2);
        new Thread(Ess.tg, this.fadeThread).start();
    }

    public void stopFade() {
        this.fadeThread.stop();
    }

    public void panTo(float f, int n) {
        this.panTo(f, n, 3);
    }

    public void panTo(float f, int n, int n2) {
        this.stopPan();
        this.panThread.setup(f, n, n2);
        new Thread(Ess.tg, this.panThread).start();
    }

    public void stopPan() {
        this.panThread.stop();
    }

    protected float[] getAudioData() {
        return this.buffer;
    }

    protected static final float softClip(float f) {
        return (float)(Math.atan(f) * 0.6);
    }

    protected final int getBufferStartTime() {
        return this.rBufferStartTime;
    }

    protected final float getSampleRate() {
        return this.rSampleRate;
    }

    protected final int getState() {
        return this.rState;
    }

    protected final class EventDispatcher
    implements Runnable {
        public boolean kill;
        public boolean trigger;
        private Method theMethod;
        private AudioOutput parent;

        EventDispatcher(Method method, AudioOutput audioOutput2) {
            this.theMethod = method;
            this.parent = audioOutput2;
        }

        public void run() {
            this.trigger = false;
            this.kill = false;
            while (!this.kill) {
                if (this.trigger) {
                    try {
                        this.theMethod.invoke((Object)Ess.parent, this.parent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.trigger = false;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected final class PanThread
    implements Runnable {
        private long startTime;
        private int duration;
        private int curve;
        private float startPan;
        private float targetPan;
        private boolean kill;

        protected PanThread() {
        }

        public void run() {
            this.kill = false;
            AudioOutput.this.rPanning = true;
            AudioOutput.this.panning = true;
            this.startTime = System.currentTimeMillis();
            this.startPan = AudioOutput.this.rPan;
            while (System.currentTimeMillis() < this.startTime + (long)this.duration && !this.kill) {
                float f = 0.0f;
                float f2 = Math.min(1.0f, (float)(System.currentTimeMillis() - this.startTime) / (float)this.duration);
                switch (this.curve) {
                    case 1: {
                        f = Ess.semiBezier(this.startPan, this.targetPan, (this.startPan * 3.0f + this.targetPan) / 4.0f, f2);
                        break;
                    }
                    case 2: {
                        f = Ess.semiBezier(this.startPan, this.targetPan, (this.startPan + this.targetPan * 3.0f) / 4.0f, f2);
                        break;
                    }
                    case 3: {
                        f = (1.0f - f2) * this.startPan + f2 * this.targetPan;
                    }
                }
                AudioOutput.this.pan(f);
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.kill) {
                AudioOutput.this.pan(this.targetPan);
                if (AudioOutput.this.audioOutputPanED != null) {
                    AudioOutput.this.audioOutputPanED.trigger = true;
                }
            }
            AudioOutput.this.rPanning = false;
            AudioOutput.this.panning = false;
        }

        void setup(float f, int n, int n2) {
            this.targetPan = f;
            this.duration = n;
            this.curve = n2;
        }

        private void stop() {
            this.kill = true;
            while (AudioOutput.this.rPanning) {
            }
        }
    }

    protected final class FadeThread
    implements Runnable {
        private long startTime;
        private int duration;
        private int curve;
        private float startVolume;
        private float targetVolume;
        public boolean kill;

        protected FadeThread() {
        }

        public void run() {
            this.kill = false;
            AudioOutput.this.rFading = true;
            AudioOutput.this.fading = true;
            this.startTime = System.currentTimeMillis();
            this.startVolume = AudioOutput.this.rVolume;
            while (System.currentTimeMillis() < this.startTime + (long)this.duration && !this.kill) {
                float f = this.startVolume;
                float f2 = Math.min(1.0f, (float)(System.currentTimeMillis() - this.startTime) / (float)this.duration);
                switch (this.curve) {
                    case 1: {
                        f = Ess.semiBezier(this.startVolume, this.targetVolume, (this.startVolume * 3.0f + this.targetVolume) / 4.0f, f2);
                        break;
                    }
                    case 2: {
                        f = Ess.semiBezier(this.startVolume, this.targetVolume, (this.startVolume + this.targetVolume * 3.0f) / 4.0f, f2);
                        break;
                    }
                    case 3: {
                        f = (1.0f - f2) * this.startVolume + f2 * this.targetVolume;
                    }
                }
                AudioOutput.this.volume(f);
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.kill) {
                AudioOutput.this.volume(this.targetVolume);
                if (AudioOutput.this.audioOutputFadeED != null) {
                    AudioOutput.this.audioOutputFadeED.trigger = true;
                }
            }
            AudioOutput.this.rFading = false;
            AudioOutput.this.fading = false;
        }

        void setup(float f, int n, int n2) {
            this.targetVolume = f;
            this.duration = n;
            this.curve = n2;
        }

        private void stop() {
            this.kill = true;
            while (AudioOutput.this.rFading) {
            }
        }
    }
}

