;    .-.
; /".\ /."\
; "-. o .-"  interflora
;  ." . ".
;  '-' '-'   gasman / h-prg for outline 2013


	org 0xc019 ; fiddle the start address so that we start with C=0x19 when invoked with USR

; yes, we're piggybacking on the ROM calculator routines. Just a little bit.
CALC_JUMP_TRUE	equ 0x00
CALC_EXCHANGE	equ 0x01
CALC_DELETE		equ 0x02
CALC_SUBTRACT	equ 0x03
CALC_MULTIPLY	equ 0x04
CALC_DIVISION	equ 0x05
CALC_ADDITION	equ 0x0f
CALC_SIN		equ 0x1f
CALC_ATN		equ 0x24
CALC_INT		equ 0x27
CALC_SQR		equ 0x28
CALC_ABS		equ 0x2a
CALC_DUPLICATE	equ 0x31
CALC_N_MOD_M	equ 0x32
CALC_CONST		equ 0x34
CALC_GREATER_0	equ 0x37
CALC_STK_ZERO	equ 0xa0
CALC_STK_ONE	equ 0xa1
CALC_STK_HALF	equ 0xa2
CALC_STK_HALF_PI	equ 0xa3
CALC_STK_TEN	equ 0xa4
CALC_ST_MEM_0	equ 0xc0
CALC_ST_MEM_1	equ 0xc1
CALC_ST_MEM_2	equ 0xc2
CALC_ST_MEM_3	equ 0xc3
CALC_ST_MEM_4	equ 0xc4
CALC_ST_MEM_5	equ 0xc5
CALC_GET_MEM_0	equ 0xe0
CALC_GET_MEM_1	equ 0xe1
CALC_GET_MEM_2	equ 0xe2
CALC_GET_MEM_3	equ 0xe3
CALC_GET_MEM_4	equ 0xe4
CALC_GET_MEM_5	equ 0xe5
CALC_END_CALC	equ	0x38

CALC 	equ 0x28 ; ROM routine to invoke calculator stack operations
STACK_BC	equ 0x2d2b ; ROM routine to put BC on the calculator stack

tbl 	equ 0xf800
sine	equ 0x7f00

	; fill screen with background pattern
	ld d,0x3f ; somewhere before start of screen memory
	ld b,c ; 0x19, enough loop iterations to fill the screen (with a bit left over)
	ld h,b ; somewhere in ROM
background_lp
	ld a,(hl)
	and 0xaa
	ld (de),a
	inc de
	cpi
	jp pe,background_lp

; Generate the screen lookup table

	ld b,0x03 ; 768 bytes (c is already 0 here)
	ld hl,tbl

tbl_lp
	push hl

		; [0] we can store it in the sine table.

		ld h,high sine
		ld (hl),a
		; (it doesn't matter that this is a junk byte on the first iteration of the loop,
		; because we'll wrap around a couple of times)

	push bc

	dec bc ; some kind of off-by-one error. Meh
	call STACK_BC ; push the table index counter

	rst CALC

	db CALC_DUPLICATE ; save a copy of BC. This will be important later.

	; divide the table index counter modulo 32 to give screen X/Y coords
	db CALC_CONST, 0x36, 0x00 ; 32 = 86 00 00 00 00 in FP notation => 36 00 in condensed notation
	db CALC_N_MOD_M

	; subtract 12.5 from screen Y to put origin in the centre
	db CALC_CONST, 0x34, 0x48 ; 12.5 = 84 48 00 00 00 in FP notation
	db CALC_SUBTRACT

	; store in calc memory 4 (because sqr and higher maths functions tend to clobber slots 0-3)
	db CALC_ST_MEM_4

	; square it
	db CALC_DUPLICATE
	db CALC_MULTIPLY

	; adjust X similarly
	db CALC_EXCHANGE
	db CALC_CONST, 0x34, 0x78 ; 15.5 = 84 78 00 00 00 in FP notation
	db CALC_SUBTRACT

	; store in calc memory 5
	db CALC_ST_MEM_5

	; square it
	db CALC_DUPLICATE
	db CALC_MULTIPLY

	; pythagorasify
	db CALC_ADDITION ; calculate x+y
	db CALC_SQR

	; get angle: atn x/y
	db CALC_GET_MEM_5 ; x
	db CALC_GET_MEM_4 ; y
	db CALC_DIVISION
	db CALC_ATN
	; fix ATN for negative values: subtract pi if y<0
	db CALC_GET_MEM_4
	db CALC_GREATER_0
	db CALC_JUMP_TRUE,5 ; skip 5 bytes (including this offset byte)
		db CALC_STK_HALF_PI, CALC_SUBTRACT ; subtract half pi
		db CALC_STK_HALF_PI, CALC_SUBTRACT ; subtract half pi

	db CALC_ST_MEM_5 ; store angle

	; sin(a*2.5)
	db CALC_CONST, 0x32, 0x20 ; 2.5 = 82 20 00 00 00 in FP notation
	db CALC_MULTIPLY
	db CALC_SIN

	; r/sin(a*2.5)
	db CALC_DIVISION

;	; + a * 128 / PI
	db CALC_GET_MEM_5 ; recall angle
	db CALC_CONST, 0x36, 0x22; 128/pi = 86 22 f9 83 53 in FP notation
	db CALC_MULTIPLY
	db CALC_ADDITION

	; put an integer-ified version of the result into calc memory 4
	db CALC_INT
	db CALC_ST_MEM_4
	db CALC_DELETE

	; Remember that copy of BC we made? We now use it to compute a byte for the sine table.
	; OHAI MR CHEKOV I FOUND UR GUN.
	db CALC_CONST, 0x2b, 0x49 ;const pi/128 (low precision)
	db CALC_MULTIPLY
	db CALC_SIN
	db CALC_CONST, 0x38, 0x01		; const 255ish
	db CALC_MULTIPLY
	db CALC_INT
	db CALC_ST_MEM_5
;	db CALC_DELETE ; we don't need no stinking balanced stack

	db CALC_END_CALC

	ld a,(iy+0x6e)			; third byte of calculator memory 4
	pop bc
	pop hl
	ld (hl),a

	ld a,(iy+0x73)			; get the third byte of the sine result (calc memory 5), so that
							; on the next loop round, after we've pushed HL, [0]

	out (254),a ; flash the border to show that we haven't crashed. :-P.
		; Also, by having it at this point in the code, it happens to end on a black border.
		; I don't know whether that's coincidental, but it does the job...

	cpi
	jp pe,tbl_lp


	ld b,high sine
frame_lp
	halt

	ld hl,tbl
	ld d,0x5a ; de = 0x5aff, end of screen memory (at least, it will be 0x5aff from the second frame onwards)
pix_lp
	ld a,(bc)
	add a,(hl)
	and b ; b = 0x7f, which as well as being the address of the sine table is exactly what we need to mask out the flash bit

	ld (de),a
	inc hl
	dec de
	bit 3,d
	jr nz,pix_lp

	inc c
	jr frame_lp
