
class ProstProcess
{
    world = null;
    shader = null;

    borderRect=null;

    rect=null;
    texRamp=null;
    texAquarell=null;

    doRamp=null;
    animRamp=null;

    doGlow=null;
    animGlow=null;

    doAquarell=null;
    animAquarell=null;

    doVignette=null;
    animVignette=null;

    doSSAO=null;
    animSSAO=null;

    doRedBlurAnim=null;
    doRedBlur=null;

    animFFT=null;

    fadeBlack=null;
    fadeBlackAnim=null;

    aquaScroll=null;
    aquaScrollAnim=null;


    constructor()
    {
        world = World();

        getSystem().setAspectRatio(1280.0/720.0);
        rect=world.createRect("fullscreenrect",getSystem().getWidth(),getSystem().getWidth()*0.5625);

        //rect=world.createRect("fullscreenrect",getSystem().getWidth(),getSystem().getHeight());
        //rect=world.createRect("fullscreenrect",1024,1024);
        rect.setPosition(getSystem().getWidth()/2,getSystem().getHeight()/2);
        rect.isOrtho=true;
        rect.setScale(1,-1,1);

        borderRect=world.createRect("fullscreenrect",getSystem().getWidth(),getSystem().getHeight());
        borderRect.setPosition(getSystem().getWidth()/2,getSystem().getHeight()/2,-1);
        borderRect.getMaterial().setDiffuseColor(0,0,0);
        borderRect.isOrtho=true;


        shader = Shader();

        animGlow=Anim();
        animFFT=AnimFFT();


        local fft=shader.createUniform("fft");
        fft.animValue=animFFT;
        animFFT.mul=2.0;
        animFFT.start=3;
        animFFT.end=20;

        doGlow=shader.createUniform("doGlow");
        doGlow.animValue=animGlow;
        animGlow.setValue(0,0.01);
        animGlow.setValue(4,0.01);
        animGlow.setValue(6,0.7);
        animGlow.setValue(75,0.7);
        animGlow.setValue(80,0.0);
        animGlow.setValue(130,0.0);

        aquaScrollAnim=Anim();
        aquaScroll=shader.createUniform("aquaScroll");
        aquaScroll.animValue=aquaScrollAnim;
        aquaScrollAnim.setValue(0,0.0);

        aquaScrollAnim.setValue(65,65.0*0.6);
        aquaScrollAnim.setValue(80,65.0*0.6);
        aquaScrollAnim.setValue(105,80.0*0.6);

        aquaScrollAnim.setValue(130,80.0*0.6);


        doRedBlurAnim=Anim();
        doRedBlur=shader.createUniform("doRedBlur");
        doRedBlur.animValue=doRedBlurAnim;
        doRedBlurAnim.setValue(0,0.0);
        doRedBlurAnim.setValue(100,0.0);
        doRedBlurAnim.setValue(130,1.0);

        fadeBlackAnim=Anim();
        fadeBlack=shader.createUniform("fadeBlack");
        fadeBlack.animValue=fadeBlackAnim;
        fadeBlackAnim.setValue(0.0,1.0);
        fadeBlackAnim.setValue(126.0,1.0);
        fadeBlackAnim.setValue(128.0,0.0);




        doVignette=shader.createUniform("doVignette");
        animVignette=Anim();
        animVignette.setValue(0,0.9);
        animVignette.setValue(7.5,0.0);
        animVignette.setValue(79.9,0.0);
        animVignette.setValue(79.99,0.4);
        doVignette.animValue=animVignette;



        doAquarell=shader.createUniform("doAquarell");
        animAquarell=Anim();
        doAquarell.animValue=animAquarell;
        animAquarell.setValue(0,0.0);
        animAquarell.setValue(7.5,0.1);
        animAquarell.setValue(8,0.6);


        doRamp=shader.createUniform("doRamp");
        animRamp=Anim();
        doRamp.animValue=animRamp;
        animRamp.setValue(0,0.1);
        animRamp.setValue(7.5,0.1);
        animRamp.setValue(8,1.0);

        doSSAO=shader.createUniform("doSSAO");
        animSSAO=Anim();

        doSSAO.animValue=animSSAO;
        animSSAO.setValue(0,0.0);
        animSSAO.setValue(34.5,0.1);

        animSSAO.setValue(35.0,1.0);


        texRamp = Texture();
        texRamp.load(getSystem().findFile("ramp.png"));


        local frag=getSystem().loadTextFile(getSystem().findFile("post.fs"));
        shader.compile(shader.getMinimalVertexShader(),frag);
        shader.setTexture("texRamp",texRamp);


        texAquarell = Texture();
        texAquarell.load(getSystem().findFile("aquarelloverlay.jpg"));
        shader.setTexture("texAquarell",texAquarell);

        rect.getMaterial().setCustomShader(shader);
    }

    function setTexture(tex)
    {
        shader.setTexture("map_diffuse",tex);
    }

    function setTextureDepth(tex)
    {
        shader.setTexture("texDepth",tex);
    }



}

