uniform vec2 u_direction;
uniform vec2 u_size;

varying vec2 v_texCoord0;

const vec2 lane = vec2(0.4);
const vec2 mid = vec2(0.5);

const vec3 c_road = vec3(0.075);

vec2 within(in vec2 uv, in vec2 p, in vec2 w, in vec2 dd) {	
	return 1.0 - smoothstep(w, w + dd, abs(uv - p));		
}

void main(void)
{
	vec2 uv = mod(v_texCoord0 * u_size, vec2(1.0));			
	vec2 dd = vec2( fwidth(v_texCoord0.x));
	vec3 col = vec3(0.0);	
	
	// lane	
	vec2 road = u_direction * within(uv, mid, lane, dd);
	col += c_road * clamp(0.0, 1.0, road.x + road.y);

	
	gl_FragColor = vec4(col, 1.0);
}