uniform float u_time;
uniform float u_moon;
uniform vec3 u_camDirection;
uniform vec3 u_camPosition;
uniform float u_death;

varying vec2 v_texCoord0;

const vec3 camera_up = vec3(0, 1, 0);
const float skyLevel = 400.0;

const vec3 sun = normalize(vec3(0.0, -1.0, 1.0));
const vec3 moon = normalize(vec3(2.0, 1.0, -1.0));

	
float hash( float n )
{
    return fract(sin(n)*43758.5453);
}

float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);

    f = f*f*(3.0-2.0*f);
    float n = p.x + p.y*57.0 + 113.0*p.z;
    return mix(mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
                   mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
               mix(mix( hash(n+113.0), hash(n+114.0),f.x),
                   mix( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
}

float clouds(vec3 p) {
	vec3 q = p + vec3(0.0, 0.25, 1.0)*u_time;
	float v = 0.0;
	v += 0.500 * (noise(q*0.0085));
	v += 0.250 * (noise(q*0.020));
	v += 0.125 * (noise(q*0.030));
	return v;
}

void main(void)
{
	vec3 direction = normalize(u_camDirection);
	vec3 left = normalize(cross(camera_up, direction));
	vec3 up = cross(direction, left);
	
	vec2 uv = vec2(v_texCoord0.x, v_texCoord0.y);
	
	vec3 rayDir = normalize(direction + uv.x * left + uv.y * up);
	vec3 rayPos = u_camPosition + rayDir;	
	
	float t = (skyLevel - rayPos.y) / rayDir.y;	
	if (0.0 < t ) {				
		vec3 col = vec3(0.0);
		
		vec3 pos = floor(100.0 * t * rayDir) / 100.0;
		
		// clouds
		float cloudA = (smoothstep(0.0, 1.0, skyLevel/t)) * 0.25;		
		float cloud = smoothstep(0.3, 0.8, clouds(pos));		
		col += cloudA * cloud * mix(vec3(1.0), vec3(1.0, 0.0, 0.0), u_death);				
		
		// sun
		float sunA = clamp(dot(sun, rayDir), 0.0, 1.0);
		col += mix(vec3(0.0, 0.0, 0.1), vec3(0.1, 0.0, 0.0), u_death) * (1.0 - cloudA);				
		col += mix(vec3(0.1, 0.2, 0.3), vec3(0.3, 0.2, 0.1), u_death) * sunA;
		col += vec3(0.5, 0.05, 0.0) * smoothstep(0.5, 1.0, sunA);

		// moon
		float cloudShade = 1.0 - smoothstep(0.0, 0.6 , cloud);
		float moonDot = dot(moon, rayDir);
		float moonA = smoothstep(0.9986/u_moon, 0.999/u_moon, moonDot);
		
		float ms = smoothstep(0.1, 0.9, noise(rayDir*50.0/u_moon));		
		vec3 mCol = vec3(0.3, 0.3, 0.3 - u_death * 0.15) - 0.1*ms;
		col += (moonA*cloudShade)*mCol;
		col += vec3(0.10, 0.10, 0.10 - 0.05 * u_death) * smoothstep(0.92, 0.9985, moonDot);
				
		// col *= pow(16.0 * uv.x * (1.0-uv.x) * uv.y * (1.0-uv.y), 0.4);

				
		gl_FragColor = vec4(col, 1.0);
	} else {
		gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
	}	
}