uniform mat4 u_projection;
uniform mat4 u_view;
uniform mat4 u_model;

attribute vec4 a_position;
attribute vec3 a_normal;

varying vec4 v_position;
varying vec3 v_normal;  

void main() {
	mat4 viewModel = u_view * u_model;

    v_normal = normalize(vec3(u_model * vec4(a_normal, 0)));
    
	v_position = viewModel * a_position;
    gl_Position = u_projection * v_position;
}