uniform mat4 u_projection;
uniform mat4 u_view;
uniform mat4 u_model;

varying vec4 v_position;
varying vec3 v_normal;

struct lightSource {
	vec4 position;
	vec4 diffuse;
	vec4 specular;
	float constantAttenuation, linearAttenuation, quadraticAttenuation;
	float spotCutoff, spotExponent;
	vec3 spotDirection;
};

struct material {
  vec4 ambient;
  vec4 diffuse;
  vec4 specular;
  float shininess;
};


lightSource light0 = lightSource(
  vec4(0.0,  1.0,  -2.0, 0.0),
  vec4(1.0,  1.0,  1.0, 1.0),
  vec4(1.0,  1.0,  1.0, 1.0),
  0.0, 1.0, 0.0,
  180.0, 0.0,
  vec3(0.0, 0.0, 0.0)
);
vec4 scene_ambient = vec4(0.2, 0.2, 0.2, 1.0);

material mat0 = material(
  vec4(0.2, 0.2, 0.2, 1.0),
  vec4(1.0, 0.8, 0.8, 1.0),
  vec4(1.0, 1.0, 1.0, 1.0),
  5.0
);
  

void main() {
	vec3 viewDirection = normalize(v_position.xyz);
	vec3 lightDirection = normalize(vec3(light0.position));
	float attenuation = 1.0;

	float dotLight = dot(v_normal, lightDirection);

	vec3 ambientLighting = vec3(scene_ambient) * vec3(mat0.ambient);
	vec3 diffuseReflection = attenuation * vec3(light0.diffuse) * vec3(mat0.diffuse) * max(0.0, dotLight);
	vec3 specularReflection;
	
  	if (dotLight < 0.0) {
  		// light source on the wrong side?
      	specularReflection = vec3(0.0, 0.0, 0.0); // no specular reflection
    } else {
		specularReflection = attenuation * vec3(light0.specular) * vec3(mat0.specular) * pow(max(0.0, dot(reflect(-lightDirection, v_normal), viewDirection)), mat0.shininess);
    }
	
	gl_FragColor = vec4(ambientLighting + diffuseReflection + specularReflection, 1.0);
    // gl_FragColor = vec4(diffuseReflection, 1.0);
	// gl_FragColor = vec4(v_normal, 1);
}