/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes.building;

import java.util.Random;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.Vector2f;

public class RandomRect {
    private final Random random;
    private final Vector2f unit;

    public RandomRect(Vector2f vector2f, long l) {
        this.random = new Random(l);
        this.unit = vector2f;
    }

    private float roundX(float f) {
        return (float)(Math.floor(f / this.unit.x) * (double)this.unit.x);
    }

    private float roundY(float f) {
        return (float)(Math.floor(f / this.unit.y) * (double)this.unit.y);
    }

    public RectBuilder bounds(Rectangle rectangle) {
        return new RectBuilder(rectangle);
    }

    public class RectBuilder {
        private final Rectangle base;
        private Float minSize;
        private Float maxSize;
        private Float aspect;
        private boolean center;
        private boolean centered;

        public RectBuilder(Rectangle rectangle) {
            this.base = rectangle;
        }

        public RectBuilder size(float f, float f2) {
            this.minSize = Float.valueOf(f);
            this.maxSize = Float.valueOf(f2);
            return this;
        }

        public RectBuilder center() {
            this.center = true;
            return this;
        }

        public RectBuilder centered() {
            this.centered = true;
            return this;
        }

        public RectBuilder aspect(float f, float f2) {
            this.aspect = Float.valueOf(RandomRect.this.random.nextFloat() * (f2 - f) + f);
            return this;
        }

        public Rectangle get() {
            if (this.minSize == null || this.maxSize == null) {
                return this.base;
            }
            Vector2f vector2f = this.buildSize();
            vector2f.x = RandomRect.this.roundY(vector2f.x);
            vector2f.y = RandomRect.this.roundY(vector2f.y);
            Vector2f vector2f2 = this.buildPosition(vector2f);
            float f = this.base.x + vector2f2.x;
            float f2 = this.base.y + vector2f2.y;
            return new Rectangle(f, f2, vector2f.x, vector2f.y);
        }

        private Vector2f buildPosition(Vector2f vector2f) {
            if (this.center) {
                float f = this.base.width / 2.0f;
                float f2 = this.base.height / 2.0f;
                float f3 = vector2f.x >= f ? ((RandomRect)RandomRect.this).unit.x : f - vector2f.x;
                float f4 = vector2f.y >= f2 ? ((RandomRect)RandomRect.this).unit.y : f2 - vector2f.y;
                float f5 = vector2f.x >= f ? this.base.width - vector2f.x - 2.0f * ((RandomRect)RandomRect.this).unit.x : f3 + vector2f.x;
                float f6 = vector2f.y >= f2 ? this.base.height - vector2f.y - 2.0f * ((RandomRect)RandomRect.this).unit.y : f4 + vector2f.y;
                float f7 = RandomRect.this.random.nextFloat() * (f5 - f3) + f3;
                float f8 = RandomRect.this.random.nextFloat() * (f6 - f4) + f4;
                return new Vector2f(RandomRect.this.roundX(f7), RandomRect.this.roundY(f8));
            }
            if (this.centered) {
                float f = (this.base.width - vector2f.x) / 2.0f;
                float f9 = (this.base.height - vector2f.y) / 2.0f;
                return new Vector2f(f, f9);
            }
            float f = RandomRect.this.random.nextFloat() * (this.base.width - vector2f.x);
            float f10 = RandomRect.this.random.nextFloat() * (this.base.height - vector2f.y);
            return new Vector2f(RandomRect.this.roundX(f), RandomRect.this.roundY(f10));
        }

        private Vector2f buildSize() {
            if (this.aspect != null) {
                if (RandomRect.this.random.nextBoolean()) {
                    float f = (RandomRect.this.random.nextFloat() * (this.maxSize.floatValue() - this.minSize.floatValue()) + this.minSize.floatValue()) * this.base.width;
                    float f2 = f * (1.0f - this.aspect.floatValue());
                    return new Vector2f(f, f2);
                }
                float f = (RandomRect.this.random.nextFloat() * (this.maxSize.floatValue() - this.minSize.floatValue()) + this.minSize.floatValue()) * this.base.height;
                float f3 = f * (1.0f - this.aspect.floatValue());
                return new Vector2f(f3, f);
            }
            float f = (RandomRect.this.random.nextFloat() * (this.maxSize.floatValue() - this.minSize.floatValue()) + this.minSize.floatValue()) * this.base.width;
            float f4 = (RandomRect.this.random.nextFloat() * (this.maxSize.floatValue() - this.minSize.floatValue()) + this.minSize.floatValue()) * this.base.height;
            return new Vector2f(f, f4);
        }
    }
}

