/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes.building;

import java.util.Random;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazmania.scenes.building.Builder;
import tazmania.scenes.building.Building;
import tazmania.scenes.building.BuildingType;

public class BuildingBuilder {
    private final float WINDOW_PER_UNIT = 0.5f;
    private final Vector2f winSize;
    private final Random random = new Random(200L);
    private final Builder textured = new Builder();
    private final Builder solid = new Builder();

    public BuildingBuilder(Vector2f vector2f) {
        this.winSize = vector2f;
    }

    public Building build(BuildingType buildingType) {
        return new Building(this.textured.build(), this.solid.build(), buildingType);
    }

    public ShapeExtruder shape(Rectangle rectangle) {
        Vector2f vector2f = new Vector2f(rectangle.x, rectangle.y);
        Vector2f vector2f2 = new Vector2f(rectangle.x, rectangle.y + rectangle.height);
        Vector2f vector2f3 = new Vector2f(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Vector2f vector2f4 = new Vector2f(rectangle.x + rectangle.width, rectangle.y);
        return this.shape(vector2f, vector2f2, vector2f3, vector2f4);
    }

    public ShapeExtruder shape(Vector2f ... vector2fArray) {
        return new ShapeExtruder(vector2fArray);
    }

    public class ShapeExtruder {
        private final Vector2f[] points;
        private float height;
        private float offset;
        private boolean center;

        public ShapeExtruder(Vector2f[] vector2fArray) {
            this.points = vector2fArray;
            this.offset = 0.0f;
        }

        public ShapeExtruder offset(float f) {
            this.offset = f;
            return this;
        }

        public ShapeExtruder height(float f) {
            this.height = f;
            return this;
        }

        public ShapeExtruder textured() {
            this.build(true);
            return this;
        }

        public ShapeExtruder solid() {
            if (this.center) {
                this.buildPyramid();
            } else {
                this.build(false);
            }
            return this;
        }

        public void top() {
            if (this.points.length == 4) {
                Vector3f vector3f = new Vector3f(this.points[0].x, this.offset + this.height, this.points[0].y);
                Vector3f vector3f2 = new Vector3f(this.points[1].x, this.offset + this.height, this.points[1].y);
                Vector3f vector3f3 = new Vector3f(this.points[2].x, this.offset + this.height, this.points[2].y);
                Vector3f vector3f4 = new Vector3f(this.points[3].x, this.offset + this.height, this.points[3].y);
                BuildingBuilder.this.solid.quad(vector3f, vector3f2, vector3f3, vector3f4, true);
            }
        }

        public ShapeExtruder extrudeCenter() {
            this.center = true;
            return this;
        }

        public void interleaved(boolean bl, boolean bl2) {
            int n;
            if (this.height == 0.0f) {
                return;
            }
            float f = 0.0f;
            for (n = 1; n < this.points.length; ++n) {
                f += this.roundX(this.points[n - 1].subtract(this.points[n]).length());
            }
            n = (int)(f / 0.5f);
            int n2 = (int)(this.height / 0.5f);
            int n3 = (int)(1.0f / ((BuildingBuilder)BuildingBuilder.this).winSize.x) - n;
            int n4 = (int)(1.0f / ((BuildingBuilder)BuildingBuilder.this).winSize.y) - n2;
            float f2 = this.roundX(n3 <= 0 ? 0.0f : (float)BuildingBuilder.this.random.nextInt(n3) * ((BuildingBuilder)BuildingBuilder.this).winSize.x);
            float f3 = this.roundY(n4 <= 0 ? 0.0f : (float)BuildingBuilder.this.random.nextInt(n4) * ((BuildingBuilder)BuildingBuilder.this).winSize.y);
            Rectangle rectangle = new Rectangle(f2, f3, (float)n * ((BuildingBuilder)BuildingBuilder.this).winSize.x, (float)n2 * ((BuildingBuilder)BuildingBuilder.this).winSize.y);
            boolean bl3 = !bl;
            float f4 = 0.0f;
            float f5 = 0.0f;
            for (int i = 1; i < this.points.length; ++i) {
                f5 = this.roundX(this.points[i - 1].subtract(this.points[i]).length());
                Rectangle rectangle2 = this.cut(rectangle, f4, f5, f);
                this.buildQuad(rectangle2, this.points[i - 1], this.points[i], bl3, bl2);
                bl3 = !bl3;
                f4 += f5;
            }
        }

        private void build(boolean bl) {
            int n;
            if (this.height == 0.0f) {
                return;
            }
            float f = this.roundX(this.points[this.points.length - 1].subtract(this.points[0]).length());
            for (n = 1; n < this.points.length; ++n) {
                f += this.roundX(this.points[n - 1].subtract(this.points[n]).length());
            }
            n = (int)(f / 0.5f);
            int n2 = (int)(this.height / 0.5f);
            int n3 = (int)(1.0f / ((BuildingBuilder)BuildingBuilder.this).winSize.x) - n;
            int n4 = (int)(1.0f / ((BuildingBuilder)BuildingBuilder.this).winSize.y) - n2;
            float f2 = this.roundX(n3 <= 0 ? 0.0f : (float)BuildingBuilder.this.random.nextInt(n3) * ((BuildingBuilder)BuildingBuilder.this).winSize.x);
            float f3 = this.roundY(n4 <= 0 ? 0.0f : (float)BuildingBuilder.this.random.nextInt(n4) * ((BuildingBuilder)BuildingBuilder.this).winSize.y);
            Rectangle rectangle = new Rectangle(f2, f3, (float)n * ((BuildingBuilder)BuildingBuilder.this).winSize.x, (float)n2 * ((BuildingBuilder)BuildingBuilder.this).winSize.y);
            float f4 = 0.0f;
            float f5 = this.roundX(this.points[this.points.length - 1].subtract(this.points[0]).length());
            Rectangle rectangle2 = this.cut(rectangle, f4, f5, f);
            this.buildQuad(rectangle2, this.points[this.points.length - 1], this.points[0], bl, false);
            f4 += f5;
            for (int i = 1; i < this.points.length; ++i) {
                f5 = this.roundX(this.points[i - 1].subtract(this.points[i]).length());
                rectangle2 = this.cut(rectangle, f4, f5, f);
                this.buildQuad(rectangle2, this.points[i - 1], this.points[i], bl, false);
                f4 += f5;
            }
        }

        private void buildPyramid() {
            Vector2f vector2f = new Vector2f(0.0f, 0.0f);
            for (Vector2f i : this.points) {
                vector2f.addLocal(i);
            }
            vector2f.multLocal(1.0f / (float)this.points.length);
            Vector3f vector3f = new Vector3f(vector2f.x, this.offset + this.height, vector2f.y);
            Vector3f vector3f2 = new Vector3f(this.points[this.points.length - 1].x, this.offset, this.points[this.points.length - 1].y);
            Vector3f vector3f3 = new Vector3f(this.points[0].x, this.offset, this.points[0].y);
            BuildingBuilder.this.solid.triangle(vector3f2, vector3f3, vector3f);
            for (int i = 1; i < this.points.length; ++i) {
                vector3f2 = new Vector3f(this.points[i - 1].x, this.offset, this.points[i - 1].y);
                vector3f3 = new Vector3f(this.points[i].x, this.offset, this.points[i].y);
                BuildingBuilder.this.solid.triangle(vector3f2, vector3f3, vector3f);
            }
        }

        private Rectangle cut(Rectangle rectangle, float f, float f2, float f3) {
            float f4 = rectangle.x + f / f3 * rectangle.width;
            float f5 = rectangle.width * (f2 / f3);
            if (f4 + f5 > 1.0f) {
                f4 = 0.0f;
            }
            return new Rectangle(this.roundX(f4), this.roundY(rectangle.y), this.roundX(f5), this.roundY(rectangle.height));
        }

        private float roundX(float f) {
            return (float)(Math.floor(f / ((BuildingBuilder)BuildingBuilder.this).winSize.x) * (double)((BuildingBuilder)BuildingBuilder.this).winSize.x);
        }

        private float roundY(float f) {
            return (float)(Math.floor(f / ((BuildingBuilder)BuildingBuilder.this).winSize.y) * (double)((BuildingBuilder)BuildingBuilder.this).winSize.y);
        }

        private void buildQuad(Rectangle rectangle, Vector2f vector2f, Vector2f vector2f2, boolean bl, boolean bl2) {
            Vector3f vector3f = new Vector3f(vector2f.x, this.offset, vector2f.y);
            Vector3f vector3f2 = new Vector3f(vector2f2.x, this.offset, vector2f2.y);
            Vector3f vector3f3 = new Vector3f(vector2f.x, this.offset + this.height, vector2f.y);
            Vector3f vector3f4 = new Vector3f(vector2f2.x, this.offset + this.height, vector2f2.y);
            if (bl) {
                BuildingBuilder.this.textured.quad(vector3f, vector3f3, vector3f4, vector3f2, rectangle, bl2);
            } else {
                BuildingBuilder.this.solid.quad(vector3f, vector3f3, vector3f4, vector3f2, bl2);
            }
        }
    }
}

