/*
 * Decompiled with CFR 0.152.
 */
package tazmania.scenes;

import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.camera.Camera;
import tazadum.engine.rendering.effect.BlurEffect;
import tazadum.engine.rendering.effect.FullscreenQuad;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.rendering.shader.NightSkyShader;
import tazadum.engine.ui.CameraControl;
import tazmania.PostFrameEffect;

public class NightSkyScene
implements Scene {
    private final RenderEngine engine;
    private FullscreenQuad quad;
    private final NightSkyShader shader;
    private final PostFrameEffect postEffect;
    private final BlurEffect blurEffect;
    private Vector3f post;
    private final Parameter<Vector2f> skyTime;

    @Inject
    public NightSkyScene(RenderEngine renderEngine, ParameterFactory parameterFactory, NightSkyShader nightSkyShader, PostFrameEffect postFrameEffect, BlurEffect blurEffect, CameraControl cameraControl) {
        this.engine = renderEngine;
        this.shader = nightSkyShader;
        this.postEffect = postFrameEffect;
        this.blurEffect = blurEffect;
        this.quad = new FullscreenQuad(1.0f);
        this.skyTime = parameterFactory.tween2f(this, "sky-time");
        this.post = new Vector3f(0.0f, 1.0f, 0.0f);
    }

    public void setPostFx(Vector3f vector3f) {
        this.post = vector3f;
    }

    @Override
    public void onPreCalc() {
    }

    @Override
    public void onInit(GL gL) {
        this.engine.addEffect(this.blurEffect);
        this.quad = new FullscreenQuad(1.0f, this.engine.getRatio());
    }

    @Override
    public void onDeinit(GL gL) {
        this.engine.removeEffect(this.blurEffect);
    }

    @Override
    public void onUpdate(GL2 gL2, float f, float f2, float f3, float f4) {
        this.postEffect.setPixelation(this.post.x * 0.1f);
        this.postEffect.setAlpha(this.post.y);
        this.postEffect.setBlend(this.post.z);
        Camera camera = this.engine.getCamera();
        Vector2f vector2f = this.skyTime.get(f);
        this.shader.enable(gL2);
        this.shader.bindTime(gL2, 50.0f * (f2 + vector2f.x));
        this.shader.bindRatio(gL2, 1.0f * this.engine.getRatio());
        this.shader.bindPosition(gL2, camera.getPosition());
        this.shader.bindDirection(gL2, camera.getDirection());
        this.shader.bindVertices(gL2, this.quad.getVertexBuffer());
        this.shader.bindTextureChoord0(gL2, this.quad.getTextureBuffer());
        this.shader.bindMoon(gL2, 1.0f);
        this.shader.bindDeath(gL2, vector2f.y);
        this.quad.draw((GL)gL2);
        gL2.glClear(256);
        gL2.glEnable(2929);
    }

    @Override
    public void onStart(Node<MeshNode> node, Interval interval) {
    }

    @Override
    public void onStop(Node<MeshNode> node) {
    }
}

