/*
 * Decompiled with CFR 0.152.
 */
package tazmania.gfx;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GL2;
import tazadum.engine.math.Box;
import tazadum.engine.math.Vector3f;
import tazadum.engine.memory.Buffers;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.rendering.mesh.Mesh;

public class Band
implements Mesh {
    private final FloatBuffer vertices;
    private final ShortBuffer indices;
    private final float length;
    private final int segments;
    private final float[] temp = new float[6];

    public Band(float f, int n, float f2) {
        this.length = f;
        this.segments = n;
        this.vertices = Buffers.allocateFloat(6 * n);
        this.indices = Buffers.allocateShort(2 * n);
        for (int i = 0; i < this.indices.capacity(); ++i) {
            this.indices.put((short)i);
        }
        this.indices.rewind();
    }

    public void update(int n, Vector3f vector3f, Vector3f vector3f2, float f) {
        this.temp[0] = vector3f.x + f * vector3f2.x;
        this.temp[1] = vector3f.y + f * vector3f2.y;
        this.temp[2] = vector3f.z + f * vector3f2.z;
        this.temp[3] = vector3f.x - f * vector3f2.x;
        this.temp[4] = vector3f.y - f * vector3f2.y;
        this.temp[5] = vector3f.z - f * vector3f2.z;
        this.vertices.position(n * 6);
        this.vertices.put(this.temp);
    }

    public void update(float f, Parameter<Vector3f> parameter, Parameter<Vector3f> parameter2, Parameter<Float> parameter3) {
        float f2 = this.length / (float)this.segments;
        for (int i = 0; i < this.segments; ++i) {
            float f3 = f - (float)i * f2;
            float f4 = parameter3.get(f3).floatValue();
            Vector3f vector3f = parameter.get(f3);
            Vector3f vector3f2 = parameter2.get(f3).normalizeLocal();
            this.temp[0] = vector3f.x + f4 * vector3f2.x;
            this.temp[1] = vector3f.y + f4 * vector3f2.y;
            this.temp[2] = vector3f.z + f4 * vector3f2.z;
            this.temp[3] = vector3f.x - f4 * vector3f2.x;
            this.temp[4] = vector3f.y - f4 * vector3f2.y;
            this.temp[5] = vector3f.z - f4 * vector3f2.z;
            this.vertices.put(this.temp);
        }
    }

    @Override
    public FloatBuffer getVertices() {
        this.vertices.rewind();
        return this.vertices;
    }

    @Override
    public void draw(GL2 gL2) {
        this.indices.rewind();
        gL2.glDrawElements(5, this.indices.capacity(), 5123, (Buffer)this.indices);
    }

    @Override
    public FloatBuffer getNormals() {
        return null;
    }

    @Override
    public FloatBuffer getTextureChoords() {
        return null;
    }

    @Override
    public IntBuffer getIndices() {
        return null;
    }

    @Override
    public Box getBoundingBox() {
        return null;
    }
}

