/*
 * Decompiled with CFR 0.152.
 */
package tazadum.matrix;

import tazadum.matrix.Mat4;
import tazadum.matrix.Vec3;
import tazadum.matrix.Vec4;

public class Matrix {
    private static float[] t = new float[16];

    public static Mat4 identity(Mat4 mat4) {
        float[] fArray = mat4.data;
        for (int i = 0; i < 16; ++i) {
            fArray[i] = 0.0f;
        }
        fArray[0] = 1.0f;
        fArray[5] = 1.0f;
        fArray[10] = 1.0f;
        fArray[15] = 1.0f;
        return mat4;
    }

    public static Mat4 mul(Mat4 mat4, Mat4 mat42, Mat4 mat43) {
        int n;
        float[] fArray = mat42.data;
        float[] fArray2 = mat43.data;
        for (n = 0; n < 4; ++n) {
            Matrix.t[0 + n] = fArray[0 + n] * fArray2[0] + fArray[4 + n] * fArray2[1] + fArray[8 + n] * fArray2[2] + fArray[12 + n] * fArray2[3];
            Matrix.t[4 + n] = fArray[0 + n] * fArray2[4] + fArray[4 + n] * fArray2[5] + fArray[8 + n] * fArray2[6] + fArray[12 + n] * fArray2[7];
            Matrix.t[8 + n] = fArray[0 + n] * fArray2[8] + fArray[4 + n] * fArray2[9] + fArray[8 + n] * fArray2[10] + fArray[12 + n] * fArray2[11];
            Matrix.t[12 + n] = fArray[0 + n] * fArray2[12] + fArray[4 + n] * fArray2[13] + fArray[8 + n] * fArray2[14] + fArray[12 + n] * fArray2[15];
        }
        for (n = 0; n < 16; ++n) {
            mat4.data[n] = t[n];
        }
        return mat4;
    }

    public static Vec4 mul(Vec4 vec4, Vec4 vec42, Mat4 mat4) {
        float[] fArray = mat4.data;
        float f = vec42.x * fArray[0] + vec42.y * fArray[1] + vec42.z * fArray[2] + vec42.w * fArray[3];
        float f2 = vec42.x * fArray[4] + vec42.y * fArray[5] + vec42.z * fArray[6] + vec42.w * fArray[7];
        float f3 = vec42.x * fArray[8] + vec42.y * fArray[9] + vec42.z * fArray[10] + vec42.w * fArray[11];
        float f4 = vec42.x * fArray[12] + vec42.y * fArray[13] + vec42.z * fArray[14] + vec42.w * fArray[15];
        vec4.x = f;
        vec4.y = f2;
        vec4.z = f3;
        vec4.w = f4;
        return vec4;
    }

    public static Vec3 mul(Vec3 vec3, Vec3 vec32, Mat4 mat4) {
        float[] fArray = mat4.data;
        float f = vec32.x * fArray[0] + vec32.y * fArray[1] + vec32.z * fArray[2] + fArray[3];
        float f2 = vec32.x * fArray[4] + vec32.y * fArray[5] + vec32.z * fArray[6] + fArray[7];
        float f3 = vec32.x * fArray[8] + vec32.y * fArray[9] + vec32.z * fArray[10] + fArray[11];
        vec3.x = f;
        vec3.y = f2;
        vec3.z = f3;
        return vec3;
    }
}

