/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.timeline;

import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tazadum.engine.configuration.TimelineManager;
import tazadum.engine.math.Interval;
import tazadum.engine.time.Scale;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.event.TimeSkipActionEvent;
import tazadum.engine.ui.event.TimeTickEvent;
import tazadum.engine.ui.event.TimelineHorizontalViewEvent;
import tazadum.engine.ui.timeline.TimelineDrawer;
import tazadum.engine.util.event.EventBus;

public class TimelineView
extends JPanel {
    private static final int TICK_SPACING_PIXELS = 100;
    private final EventBus eventBus;
    private final JScrollBar scrollBar;
    private final TimelineDrawer drawer;
    private final TimeManager timeManager;
    private Interval interval;
    private final Scale scale;
    private float tickSpacingTime;
    private float offsetTime;
    private float time;

    public TimelineView(EventBus eventBus, TimelineManager timelineManager, TimeManager timeManager) {
        this.eventBus = eventBus;
        this.timeManager = timeManager;
        this.interval = timelineManager.getInterval();
        this.scale = new Scale(10.0f);
        this.drawer = new TimelineDrawer();
        this.scrollBar = new JScrollBar(0);
        this.scrollBar.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TimelineView.this.recalc(true);
                TimelineView.this.invalidate();
                TimelineView.this.repaint();
            }
        });
        eventBus.addHandler(TimeTickEvent.TYPE, new TimeTickEvent.Handler(){

            @Override
            public void onTimelineRepaint(TimeTickEvent timeTickEvent) {
                TimelineView.this.time = timeTickEvent.getTime();
                TimelineView.this.repaint();
            }
        });
        TimeListener timeListener = new TimeListener();
        this.addMouseMotionListener(timeListener);
        this.addMouseListener(timeListener);
        this.addMouseWheelListener(timeListener);
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public float getScale() {
        return this.scale.get();
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
        this.recalc(true);
    }

    public void setScale(float f) {
        this.scale.set(f);
        this.recalc(true);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.recalc(true);
    }

    public float snapTime(float f) {
        float f2 = 0.1f * this.tickSpacingTime;
        return (float)((int)(f / f2)) * f2;
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawer.paint(graphics, this.scale, this.offsetTime, this.tickSpacingTime, this.time);
    }

    private void recalc(boolean bl) {
        int n = this.getWidth();
        if (n == 0) {
            return;
        }
        float f = this.scale.fromTime(this.interval.length());
        float f2 = f - (float)n;
        if (f2 < 0.0f && bl) {
            this.scale.set((float)n / this.interval.length());
            this.recalc(false);
            return;
        }
        this.scrollBar.setEnabled(f2 > 0.0f);
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum((int)(0.5f + f2));
        this.tickSpacingTime = this.calculateSpacingInTime();
        this.offsetTime = this.scale.toTime(this.scrollBar.getValue());
        this.eventBus.fireEvent(new TimelineHorizontalViewEvent(this.scale, new Interval(this.offsetTime, this.offsetTime + this.scale.toTime(n))));
    }

    private float calculateSpacingInTime() {
        float f = this.scale.toTime(100);
        int n = (int)(0.5 + Math.log10(f));
        return (float)Math.pow(10.0, n);
    }

    private class TimeListener
    extends MouseAdapter
    implements MouseMotionListener,
    MouseWheelListener {
        private boolean pressed;

        private TimeListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            float f = 1.0f - 0.1f * (float)mouseWheelEvent.getPreciseWheelRotation();
            float f2 = TimelineView.this.getWidth();
            float f3 = TimelineView.this.scale.toTime((int)(0.5 * (double)f2 * (double)0.1f));
            TimelineView.this.offsetTime += f3;
            TimelineView.this.scale.set(TimelineView.this.scale.get() * f);
            TimelineView.this.recalc(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.pressed = true;
            this.post(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.pressed = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.post(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.post(mouseEvent);
        }

        private void post(MouseEvent mouseEvent) {
            if (this.pressed) {
                int n = mouseEvent.getX();
                TimelineView.this.timeManager.setTime(Math.max(0.0f, TimelineView.this.scale.toTime(n) + TimelineView.this.offsetTime));
                TimelineView.this.eventBus.fireEvent(new TimeSkipActionEvent(0.0f));
            }
        }
    }
}

