/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.parameter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.TweenParameter;
import tazadum.engine.ui.tween.TweenView;

public class TweenParameterUI
extends JPanel {
    private final TweenParameter parameter;
    private final TweenView view;
    private final String parameterName;
    private JFrame frame = null;

    public TweenParameterUI(String string, Parameter<?> parameter) {
        this.parameterName = string;
        this.parameter = (TweenParameter)((Object)parameter);
        this.view = new TweenView(this.parameter.getTweens());
        this.view.recalibrate();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(200, 100));
        this.setPreferredSize(new Dimension(200, 100));
        this.add((Component)this.view, "Center");
        this.view.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    TweenParameterUI.this.showInFrame();
                }
            }
        });
    }

    protected void showInFrame() {
        if (this.frame != null) {
            return;
        }
        TweenView tweenView = new TweenView(this.parameter.getTweens());
        this.frame = new JFrame(this.parameterName);
        this.frame.getContentPane().add((Component)tweenView, "Center");
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(800, 600);
        this.frame.setVisible(true);
        tweenView.recalibrate();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                TweenParameterUI.this.frame = null;
                TweenParameterUI.this.view.recalibrate();
            }
        });
    }
}

