/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.parameter;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import tazadum.engine.ui.parameter.Grid;

public class GridControl {
    protected static final float ZOOM_AMOUNT = 0.1f;
    private boolean enabled = true;

    public GridControl(final Component component, final Grid grid) {
        component.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (!GridControl.this.enabled) {
                    return;
                }
                float f = (float)mouseWheelEvent.getWheelRotation() * 0.1f;
                if ((mouseWheelEvent.getModifiersEx() & 0x80) != 0) {
                    grid.zoomX(f);
                } else if ((mouseWheelEvent.getModifiersEx() & 0x40) != 0) {
                    grid.zoomY(f);
                } else {
                    grid.zoom(f);
                }
                component.repaint();
            }
        });
        component.addMouseMotionListener(new MouseMotionAdapter(){
            private Point start;

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.start = mouseEvent.getPoint();
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!GridControl.this.enabled) {
                    return;
                }
                int n = this.start.x - mouseEvent.getPoint().x;
                int n2 = this.start.y - mouseEvent.getPoint().y;
                if (n == 0 && n2 == 0) {
                    return;
                }
                grid.pan(n, n2);
                this.start = mouseEvent.getPoint();
                component.repaint();
            }
        });
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }
}

