/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.parameter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.ui.AxisUtil;

public class Grid {
    private static final Color COLOR_AXIS = new Color(0xA0A0A0);
    private static final Color COLOR_GRID = new Color(0x404040);
    private static final Color COLOR_TEXT = new Color(0x808080);
    private static final int TICK_SPACING = 50;
    private final Rectangle area = new Rectangle(-1.0f, -1.0f, 2.0f, 2.0f);
    private final Vector2f scale = new Vector2f(1.0f, 1.0f);
    private final Font font = new Font("Areal", 0, 10);
    private FontMetrics fontMetrics;
    private int height;
    private float horizontalSpacing;
    private float verticalSpacing;

    public Rectangle area() {
        return this.area;
    }

    public void area(Rectangle rectangle) {
        this.area.copy(rectangle);
    }

    public Vector2f screenToGrid(Vector2f vector2f) {
        float f = vector2f.x * this.scale.x + this.area.x;
        float f2 = ((float)this.height - vector2f.y) * this.scale.y + this.area.y;
        return new Vector2f(f, f2);
    }

    public Vector3f screenToGrid(Vector3f vector3f) {
        float f = vector3f.x * this.scale.x + this.area.x;
        float f2 = ((float)this.height - vector3f.y) * this.scale.y + this.area.y;
        return new Vector3f(f, f2, vector3f.z);
    }

    public Vector2f gridToScreen(Vector2f vector2f) {
        float f = (vector2f.x - this.area.x) / this.scale.x;
        float f2 = (float)this.height - (vector2f.y - this.area.y) / this.scale.y;
        return new Vector2f(f, f2);
    }

    public Vector3f gridToScreen(Vector3f vector3f) {
        float f = (vector3f.x - this.area.x) / this.scale.x;
        float f2 = (float)this.height - (vector3f.y - this.area.y) / this.scale.y;
        return new Vector3f(f, f2, vector3f.z);
    }

    public void zoom(float f) {
        float f2 = this.area.width * (1.0f + f);
        float f3 = this.area.height * (1.0f + f);
        this.area.x += (this.area.width - f2) / 2.0f;
        this.area.y += (this.area.height - f3) / 2.0f;
        this.area.width = f2;
        this.area.height = f3;
    }

    public void zoomX(float f) {
        float f2 = this.area.width * (1.0f + f);
        this.area.x += (this.area.width - f2) / 2.0f;
        this.area.width = f2;
    }

    public void zoomY(float f) {
        float f2 = this.area.height * (1.0f + f);
        this.area.y += (this.area.height - f2) / 2.0f;
        this.area.height = f2;
    }

    public void pan(float f, float f2) {
        this.area.x += f * this.scale.x;
        this.area.y += -f2 * this.scale.y;
    }

    public float snapHorizontal(float f) {
        return (float)((int)(f / this.horizontalSpacing)) * this.horizontalSpacing;
    }

    public float snapVertical(float f) {
        return (float)((int)(f / this.verticalSpacing)) * this.verticalSpacing;
    }

    public void draw(Graphics graphics) {
        Vector2f vector2f;
        Vector2f vector2f2;
        if (this.fontMetrics == null) {
            this.fontMetrics = graphics.getFontMetrics();
        }
        Rectangle rectangle = new Rectangle(graphics.getClipBounds());
        this.scale.x = this.area.width / rectangle.width;
        this.scale.y = this.area.height / rectangle.height;
        this.height = (int)rectangle.height;
        graphics.setColor(Color.black);
        graphics.fillRect((int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height);
        graphics.setFont(this.font);
        this.drawGrid(graphics, rectangle);
        if (this.area.x < 0.0f && 0.0f < this.area.x + this.area.width) {
            vector2f2 = this.gridToScreen(new Vector2f(0.0f, this.area.y));
            vector2f = this.gridToScreen(new Vector2f(0.0f, this.area.y + this.area.height));
            graphics.setColor(COLOR_AXIS);
            graphics.drawLine((int)vector2f2.x, (int)vector2f2.y, (int)vector2f.x, (int)vector2f.y);
        }
        if (this.area.y < 0.0f && 0.0f < this.area.y + this.area.height) {
            vector2f2 = this.gridToScreen(new Vector2f(this.area.x, 0.0f));
            vector2f = this.gridToScreen(new Vector2f(this.area.x + this.area.width, 0.0f));
            graphics.setColor(COLOR_AXIS);
            graphics.drawLine((int)vector2f2.x, (int)vector2f2.y, (int)vector2f.x, (int)vector2f.y);
        }
    }

    private void drawGrid(Graphics graphics, Rectangle rectangle) {
        Vector2f vector2f;
        int n = (int)(rectangle.width / 50.0f);
        int n2 = (int)(rectangle.height / 50.0f);
        this.horizontalSpacing = AxisUtil.spacing(this.area.width, n);
        this.verticalSpacing = AxisUtil.spacing(this.area.height, n2);
        int n3 = (int)Math.log10(this.horizontalSpacing) - 1;
        String string = String.format("%%.%df", n3 < 0 ? -n3 : 0);
        int n4 = (int)Math.log10(this.verticalSpacing) - 1;
        String string2 = String.format("%%.%df", n4 < 0 ? -n4 : 0);
        for (float f = (float)((int)(this.area.x / this.horizontalSpacing)) * this.horizontalSpacing; f < this.area.x + this.area.width; f += this.horizontalSpacing) {
            Vector2f vector2f2 = this.gridToScreen(new Vector2f(f, this.area.y));
            vector2f = this.gridToScreen(new Vector2f(f, this.area.y + this.area.height));
            graphics.setColor(COLOR_GRID);
            graphics.drawLine((int)vector2f2.x, (int)vector2f2.y, (int)vector2f.x, (int)vector2f.y);
            if (!(f + this.horizontalSpacing * 0.25f < this.area.x + this.area.width)) continue;
            this.string(graphics, String.format(string, Float.valueOf(f)), (int)vector2f2.x, (float)this.height - vector2f2.y);
        }
        for (float f = (float)((int)(this.area.y / this.verticalSpacing)) * this.verticalSpacing; f < this.area.y + this.area.height; f += this.verticalSpacing) {
            vector2f = this.gridToScreen(new Vector2f(this.area.x, f));
            Vector2f vector2f3 = this.gridToScreen(new Vector2f(this.area.x + this.area.width, f));
            graphics.setColor(COLOR_GRID);
            graphics.drawLine((int)vector2f.x, (int)vector2f.y, (int)vector2f3.x, (int)vector2f3.y);
            if (!(f + this.verticalSpacing * 0.25f < this.area.y + this.area.height)) continue;
            this.string(graphics, String.format(string2, Float.valueOf(f)), 0.0f, (int)vector2f.y);
        }
    }

    private void string(Graphics graphics, String string, float f, float f2) {
        graphics.setColor(COLOR_TEXT);
        Rectangle2D rectangle2D = this.fontMetrics.getStringBounds(string, graphics);
        graphics.drawString(string, (int)f + 2, (int)((double)f2 + rectangle2D.getHeight()));
    }
}

