/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.layer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JPanel;
import tazadum.engine.configuration.Layer;
import tazadum.engine.configuration.LayerType;
import tazadum.engine.configuration.TimelineManager;
import tazadum.engine.configuration.TimelineScene;
import tazadum.engine.math.Interval;
import tazadum.engine.time.Scale;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.HasInterval;
import tazadum.engine.ui.UIColor;
import tazadum.engine.ui.UISize;
import tazadum.engine.ui.event.LayerEntrySelectedEvent;
import tazadum.engine.ui.event.TimelineHorizontalViewEvent;
import tazadum.engine.ui.event.TimelineVerticalViewEvent;
import tazadum.engine.ui.layer.LayerDragMode;
import tazadum.engine.ui.timeline.TimelineView;
import tazadum.engine.util.event.EventBus;

public class LayerView
extends JPanel {
    private static final int RESIZE_MARGIN = 5;
    protected static final float MINIMUM_ENTRY_LENGTH = 0.1f;
    private final TimelineManager timelineManager;
    private LayerDragMode dragMode = LayerDragMode.None;
    private boolean mouseDown = false;
    private int mouseDeltaX = 0;
    private int layerDragIndex = 0;
    private List<Layer> layers;
    private final ConcurrentMap<HasInterval, Rectangle> sizeCache = new ConcurrentHashMap<HasInterval, Rectangle>();
    private final Scale verticalScale = new Scale(1.0f);
    private final Scale horizontalScale = new Scale(1.0f);
    private Interval horizontalOffset = new Interval(0.0f, 1.0f);
    private int verticalOffset = 0;
    protected HasInterval currentEntry;
    protected HasInterval selectedEntry;

    public LayerView(final EventBus eventBus, TimelineManager timelineManager, final TimelineView timelineView, final TimeManager timeManager) {
        this.timelineManager = timelineManager;
        eventBus.addHandler(TimelineHorizontalViewEvent.TYPE, new TimelineHorizontalViewEvent.Handler(){

            @Override
            public void onHorizontalView(TimelineHorizontalViewEvent timelineHorizontalViewEvent) {
                LayerView.this.horizontalOffset = timelineHorizontalViewEvent.getInterval();
                LayerView.this.horizontalScale.set(timelineHorizontalViewEvent.getScale().get());
                LayerView.this.recalc();
                LayerView.this.invalidate();
                LayerView.this.repaint();
            }
        });
        eventBus.addHandler(TimelineVerticalViewEvent.TYPE, new TimelineVerticalViewEvent.Handler(){

            @Override
            public void onVerticalView(TimelineVerticalViewEvent timelineVerticalViewEvent) {
                LayerView.this.verticalOffset = (int)timelineVerticalViewEvent.getInterval().from();
                LayerView.this.verticalScale.set(timelineVerticalViewEvent.getScale().get());
                LayerView.this.recalc();
                LayerView.this.invalidate();
                LayerView.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (LayerView.this.mouseDown) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                HasInterval hasInterval = LayerView.this.currentEntry;
                Rectangle rectangle = null;
                LayerView.this.currentEntry = null;
                for (Map.Entry entry : LayerView.this.sizeCache.entrySet()) {
                    if (!((Rectangle)entry.getValue()).contains(n, n2)) continue;
                    LayerView.this.currentEntry = (HasInterval)entry.getKey();
                    rectangle = (Rectangle)entry.getValue();
                    break;
                }
                if (LayerView.this.currentEntry == null) {
                    LayerView.this.dragMode = LayerDragMode.None;
                } else if (n < rectangle.x + 5) {
                    LayerView.this.dragMode = LayerDragMode.ResizeLeft;
                } else if (n > rectangle.x + rectangle.width - 5) {
                    LayerView.this.dragMode = LayerDragMode.ResizeRight;
                } else {
                    LayerView.this.dragMode = LayerDragMode.Move;
                    LayerView.this.mouseDeltaX = mouseEvent.getX() - rectangle.x;
                    LayerView.this.layerDragIndex = (mouseEvent.getY() + LayerView.this.verticalOffset - UISize.Border.h) / UISize.Header.h;
                }
                LayerView.this.setCursor(((LayerView)LayerView.this).dragMode.cursor);
                if (LayerView.this.currentEntry == null ? hasInterval != null : !LayerView.this.currentEntry.equals(hasInterval)) {
                    LayerView.this.invalidate();
                    LayerView.this.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                boolean bl = (mouseEvent.getModifiersEx() & 0x40) != 0;
                switch (LayerView.this.dragMode) {
                    case None: {
                        return;
                    }
                    case ResizeRight: {
                        float f = LayerView.this.horizontalScale.toTime(n) + LayerView.this.horizontalOffset.from();
                        f = bl ? timelineView.snapTime(f) : f;
                        LayerView.this.currentEntry.setInterval(new Interval(LayerView.this.currentEntry.getInterval().from(), Math.max(f, LayerView.this.currentEntry.getInterval().from() + 0.1f)));
                        break;
                    }
                    case ResizeLeft: {
                        float f = LayerView.this.horizontalScale.toTime(n) + LayerView.this.horizontalOffset.from();
                        f = bl ? timelineView.snapTime(f) : f;
                        LayerView.this.currentEntry.setInterval(new Interval(Math.min(f, LayerView.this.currentEntry.getInterval().to() - 0.1f), LayerView.this.currentEntry.getInterval().to()));
                        break;
                    }
                    case Move: {
                        float f = LayerView.this.horizontalScale.toTime(n - LayerView.this.mouseDeltaX) + LayerView.this.horizontalOffset.from();
                        float f2 = Math.max(0.0f, f);
                        f2 = bl ? timelineView.snapTime(f2) : f2;
                        Interval interval = LayerView.this.currentEntry.getInterval();
                        LayerView.this.currentEntry.setInterval(new Interval(f2, f2 + interval.length()));
                        int n3 = (n2 + LayerView.this.verticalOffset - UISize.Border.h) / UISize.Header.h;
                        if (n3 == LayerView.this.layerDragIndex || n3 < 0 || n3 >= LayerView.this.layers.size()) break;
                        Layer layer = (Layer)LayerView.this.layers.get(LayerView.this.layerDragIndex);
                        Layer layer2 = (Layer)LayerView.this.layers.get(n3);
                        if (layer.getType() != layer2.getType() || !LayerView.this.timelineManager.move(LayerView.this.currentEntry, layer, layer2)) break;
                        LayerView.this.layerDragIndex = n3;
                    }
                }
                LayerView.this.sizeCache.remove(LayerView.this.currentEntry);
                LayerView.this.invalidate();
                LayerView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                LayerView.this.selectedEntry = null;
                for (Map.Entry entry : LayerView.this.sizeCache.entrySet()) {
                    if (!((Rectangle)entry.getValue()).contains(n, n2)) continue;
                    LayerView.this.selectedEntry = (HasInterval)entry.getKey();
                    System.out.println("Scene localtime: " + (timeManager.getTime() - LayerView.this.selectedEntry.getInterval().from()));
                    break;
                }
                if (LayerView.this.selectedEntry != null) {
                    Object object = LayerView.this.selectedEntry;
                    if (LayerView.this.selectedEntry instanceof TimelineScene) {
                        object = ((TimelineScene)LayerView.this.selectedEntry).getScene();
                    }
                    eventBus.fireEvent(new LayerEntrySelectedEvent(object));
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LayerView.this.mouseDown = true;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                LayerView.this.mouseDown = false;
            }
        });
    }

    public void setLayers(List<Layer> list) {
        this.layers = list;
        this.recalc();
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(UIColor.Background.color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = 0;
        for (Layer layer : this.layers) {
            int n2 = rectangle.x;
            int n3 = rectangle.y + n * UISize.Header.h + UISize.Border.h - this.verticalOffset;
            int n4 = this.getWidth() - 1;
            int n5 = UISize.Header.h - 2 * UISize.Border.h;
            graphics.setColor(UIColor.Panel.color);
            graphics.fillRect(n2, n3, n4, n5);
            if (layer.getType() == LayerType.SceneLayer) {
                List<TimelineScene> list = this.timelineManager.getScenes(layer, this.horizontalOffset);
                for (TimelineScene timelineScene : list) {
                    if (timelineScene.getLayer() != layer.getIndex()) continue;
                    Rectangle rectangle2 = this.getBounds(n, timelineScene);
                    Interval interval = timelineScene.getInterval();
                    graphics.setColor(UIColor.MediumBorder.color);
                    graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    if (timelineScene.equals(this.currentEntry)) {
                        graphics.setColor(Color.red);
                    } else {
                        graphics.setColor(this.calculateEntryColor(timelineScene));
                    }
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    this.drawInterval(graphics, rectangle2, interval);
                    this.drawClassName(graphics, rectangle2, timelineScene);
                    if (!timelineScene.equals(this.selectedEntry)) continue;
                    graphics.setColor(UIColor.Indicator.color);
                    graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            }
            graphics.setColor(UIColor.Border.color);
            graphics.drawRect(n2, n3, n4, n5);
            ++n;
        }
    }

    private void drawClassName(Graphics graphics, Rectangle rectangle, TimelineScene timelineScene) {
        Class<?> clazz;
        String string;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string = (clazz = timelineScene.getScene().getClass()).getName(), graphics);
        if (rectangle2D.getWidth() > (double)(rectangle.width - 2 * UISize.Entry.w) && (rectangle2D = fontMetrics.getStringBounds(string = clazz.getSimpleName(), graphics)).getWidth() > (double)(rectangle.width - 2 * UISize.Entry.w)) {
            return;
        }
        graphics.drawString(string, rectangle.x + UISize.Entry.w, rectangle.y + fontMetrics.getHeight());
    }

    private void drawInterval(Graphics graphics, Rectangle rectangle, Interval interval) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = String.format("%.2f", Float.valueOf(interval.from()));
        String string2 = String.format("%.2f", Float.valueOf(interval.to()));
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string2, graphics);
        graphics.setColor(UIColor.Border.color);
        if (rectangle2D.getWidth() < (double)rectangle.width) {
            graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - UISize.Entry.h);
        }
        if (rectangle2D.getWidth() + rectangle2D2.getWidth() < (double)rectangle.width) {
            graphics.drawString(string2, rectangle.x + rectangle.width - (int)rectangle2D2.getWidth(), rectangle.y + rectangle.height - UISize.Entry.h);
        }
    }

    private Color calculateEntryColor(TimelineScene timelineScene) {
        Class<?> clazz = timelineScene.getScene().getClass();
        int n = clazz.getName().hashCode();
        return new Color(n);
    }

    private void recalc() {
        if (this.layers == null) {
            return;
        }
        this.sizeCache.clear();
        int n = 0;
        for (Layer layer : this.layers) {
            if (layer.getType() == LayerType.SceneLayer) {
                List<TimelineScene> list = this.timelineManager.getScenes(layer, this.horizontalOffset);
                for (TimelineScene timelineScene : list) {
                    Rectangle rectangle = this.calculateEntryBounds(n, timelineScene);
                    this.sizeCache.putIfAbsent(timelineScene, rectangle);
                }
            }
            ++n;
        }
    }

    private Rectangle getBounds(int n, HasInterval hasInterval) {
        if (!this.sizeCache.containsKey(hasInterval)) {
            this.sizeCache.put(hasInterval, this.calculateEntryBounds(n, hasInterval));
        }
        return (Rectangle)this.sizeCache.get(hasInterval);
    }

    private Rectangle calculateEntryBounds(int n, HasInterval hasInterval) {
        int n2 = n * UISize.Header.h + UISize.Border.h - this.verticalOffset;
        int n3 = UISize.Header.h - 2 * UISize.Border.h;
        Interval interval = hasInterval.getInterval();
        int n4 = 1 + this.horizontalScale.fromTime(interval.from() - this.horizontalOffset.from());
        int n5 = n2 + UISize.Entry.h;
        int n6 = this.horizontalScale.fromTime(interval.length()) - 1;
        int n7 = n3 - 2 * UISize.Entry.h;
        return new Rectangle(n4, n5, n6, n7);
    }
}

