/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.header;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tazadum.engine.configuration.Layer;
import tazadum.engine.configuration.SceneLayer;
import tazadum.engine.configuration.TimelineManager;
import tazadum.engine.math.Interval;
import tazadum.engine.time.Scale;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.UIColor;
import tazadum.engine.ui.UISize;
import tazadum.engine.ui.event.TimelineVerticalViewEvent;
import tazadum.engine.ui.layer.LayerView;
import tazadum.engine.ui.timeline.TimelineView;
import tazadum.engine.util.event.EventBus;

public class HeaderView
extends JPanel {
    private final EventBus eventBus;
    private final JScrollBar scrollBar;
    private final LayerView layerView;
    private final List<Layer> layers = new CopyOnWriteArrayList<Layer>();
    private final Scale scale = new Scale(1.0f);
    private int layerCount = 0;
    private int offset = 0;

    public HeaderView(final EventBus eventBus, TimelineManager timelineManager, TimelineView timelineView, TimeManager timeManager) {
        this.eventBus = eventBus;
        this.scrollBar = new JScrollBar(1);
        this.layerView = new LayerView(eventBus, timelineManager, timelineView, timeManager);
        this.scrollBar.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HeaderView.this.offset = HeaderView.this.scrollBar.getValue();
                HeaderView.this.invalidate();
                HeaderView.this.repaint();
                Interval interval = new Interval(HeaderView.this.offset, HeaderView.this.offset + HeaderView.this.getHeight());
                eventBus.fireEvent(new TimelineVerticalViewEvent(HeaderView.this.scale, interval));
            }
        });
        int n = Math.max(3, timelineManager.getSceneLayers());
        for (int i = 0; i < n; ++i) {
            this.layers.add(new SceneLayer(i));
        }
    }

    public LayerView getLayerView() {
        return this.layerView;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.recalc();
        Interval interval = new Interval(this.offset, this.offset + this.getHeight());
        this.eventBus.fireEvent(new TimelineVerticalViewEvent(this.scale, interval));
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    @Override
    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(UIColor.Background.color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        for (Layer layer : this.layers) {
            Rectangle rectangle2 = layer.getBounds();
            int n = rectangle.x + rectangle2.x;
            int n2 = rectangle.y + rectangle2.y - this.offset;
            int n3 = rectangle2.width;
            int n4 = rectangle2.height;
            graphics.setColor(UIColor.Panel.color);
            graphics.fillRoundRect(n, n2, n3, n4, 5, 5);
            graphics.setColor(UIColor.Border.color);
            graphics.drawRoundRect(n, n2, n3, n4, 5, 5);
            String string = String.format("%s #%d", new Object[]{layer.getType(), layer.getIndex()});
            graphics.drawString(string, n + UISize.Border.w, n2 + fontMetrics.getHeight());
        }
    }

    private void recalc() {
        this.layerView.setLayers(this.layers);
        this.layerCount = this.layers.size();
        int n = this.layerCount * UISize.Header.h + 2 * UISize.Border.h;
        if (n <= this.getHeight()) {
            this.scrollBar.setEnabled(false);
        } else {
            this.scrollBar.setEnabled(true);
            this.scrollBar.setMinimum(0);
            this.scrollBar.setMaximum(n - this.getHeight());
        }
        int n2 = 0;
        for (Layer layer : this.layers) {
            int n3 = UISize.Border.w;
            int n4 = n2 * UISize.Header.h + UISize.Border.h;
            int n5 = UISize.Header.w - 2 * UISize.Border.w;
            int n6 = UISize.Header.h - 2 * UISize.Border.h;
            layer.setBounds(new Rectangle(n3, n4, n5, n6));
            ++n2;
        }
    }
}

