/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui.component;

import java.awt.GridLayout;
import java.awt.Label;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import tazadum.engine.math.Vector3f;
import tazadum.engine.ui.HasValueChangeListener;
import tazadum.engine.ui.ValueChangeListener;
import tazadum.engine.ui.component.FloatTextField;
import tazadum.engine.ui.component.TwoPartPanel;

public class VectorTextField
extends JPanel
implements HasValueChangeListener<Vector3f> {
    private static final long serialVersionUID = -1L;
    private final Set<ValueChangeListener<Vector3f>> listeners = new HashSet<ValueChangeListener<Vector3f>>();
    private final FloatTextField x;
    private final FloatTextField y;
    private final FloatTextField z;

    public VectorTextField(Vector3f vector3f) {
        this.setLayout(new GridLayout(3, 1));
        this.x = new FloatTextField(vector3f.x);
        this.y = new FloatTextField(vector3f.y);
        this.z = new FloatTextField(vector3f.z);
        this.add(new TwoPartPanel(new Label("x:"), this.x));
        this.add(new TwoPartPanel(new Label("y:"), this.y));
        this.add(new TwoPartPanel(new Label("z:"), this.z));
        this.x.setColumns(6);
        this.y.setColumns(6);
        this.z.setColumns(6);
        this.x.addValueChangeListener(new ValueChangeListener<Float>(){

            @Override
            public void onValueChanged(Float f) {
                VectorTextField.this.notifyChange();
            }
        });
        this.y.addValueChangeListener(new ValueChangeListener<Float>(){

            @Override
            public void onValueChanged(Float f) {
                VectorTextField.this.notifyChange();
            }
        });
        this.z.addValueChangeListener(new ValueChangeListener<Float>(){

            @Override
            public void onValueChanged(Float f) {
                VectorTextField.this.notifyChange();
            }
        });
    }

    public Vector3f getValue() {
        return new Vector3f(this.x.getValue(), this.y.getValue(), this.z.getValue());
    }

    protected void notifyChange() {
        Vector3f vector3f = this.getValue();
        for (ValueChangeListener<Vector3f> valueChangeListener : this.listeners) {
            valueChangeListener.onValueChanged(vector3f);
        }
    }

    @Override
    public void addValueChangeListener(ValueChangeListener<Vector3f> valueChangeListener) {
        this.listeners.add(valueChangeListener);
    }
}

