/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LayerHeader
extends JPanel
implements Transferable {
    public static final Dimension SIZE = new Dimension(200, 40);
    public static final DataFlavor FLAVOR;
    private final DragSource dragSource;
    private final DragGestureListener dragGestureListener;
    private final DragSourceListener dragSourceListener;

    public LayerHeader(String string) {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(string), "Center");
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setMinimumSize(SIZE);
        this.setMaximumSize(SIZE);
        this.setPreferredSize(SIZE);
        this.dragSourceListener = new DragSourceAdapter(){

            @Override
            public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            }

            @Override
            public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            }

            @Override
            public void dragExit(DragSourceEvent dragSourceEvent) {
            }

            @Override
            public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
                System.out.println("dragEnter");
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                System.out.println("dragDropEnd");
                if (!dragSourceDropEvent.getDropSuccess()) {
                    return;
                }
            }
        };
        this.dragGestureListener = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                System.out.println("dragGestureRecognized");
                try {
                    LayerHeader layerHeader = LayerHeader.this;
                    dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, layerHeader, LayerHeader.this.dragSourceListener);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    System.err.println(invalidDnDOperationException);
                }
            }
        };
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this.dragGestureListener);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return FLAVOR.equals(dataFlavor);
    }

    static {
        try {
            FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=\"" + LayerHeader.class.getName() + "\"");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }
}

