/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tazadum.engine.ui.api.ChangeListener;
import tazadum.engine.ui.api.HasChangeListeners;
import tazadum.engine.ui.api.HasText;
import tazadum.engine.ui.impl.ChangeListenerContainer;

public class EditableTextLabel
extends JPanel
implements HasText,
HasChangeListeners<String> {
    private final JLabel label = new JLabel();
    private final JTextField field = new JTextField();
    private boolean labelMode;
    private final ChangeListenerContainer<String> container = new ChangeListenerContainer();

    public EditableTextLabel() {
        this("");
    }

    public EditableTextLabel(String string) {
        this.setMinimumSize(new Dimension(50, 20));
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.labelMode = true;
        this.label.setText(string);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                System.out.println(mouseEvent.getClickCount());
                if (mouseEvent.getClickCount() >= 2) {
                    EditableTextLabel.this.switchToEdit();
                    EditableTextLabel.this.refresh();
                }
            }
        });
        this.field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    EditableTextLabel.this.switchToLabel();
                    EditableTextLabel.this.refresh();
                }
            }
        });
        this.field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                EditableTextLabel.this.switchToLabel();
                EditableTextLabel.this.refresh();
            }
        });
    }

    @Override
    public void addChangeListener(ChangeListener<String> changeListener) {
        this.container.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener<String> changeListener) {
        this.container.addChangeListener(changeListener);
    }

    @Override
    public String getText() {
        return this.labelMode ? this.label.getText() : this.field.getText();
    }

    @Override
    public void setText(String string) {
        this.label.setText(string);
        this.field.setText(string);
    }

    protected void switchToLabel() {
        boolean bl;
        boolean bl2 = bl = !this.field.getText().equals(this.label.getText());
        if (bl) {
            this.container.invokeListeners(this, this.field.getText());
        }
        this.label.setText(this.field.getText());
        this.remove(this.field);
        this.add((Component)this.label, "Center");
        this.labelMode = true;
    }

    protected void switchToEdit() {
        this.field.setText(this.label.getText());
        this.remove(this.label);
        this.add((Component)this.field, "Center");
        this.labelMode = false;
    }

    protected void refresh() {
        this.doLayout();
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
        this.repaint();
    }
}

