/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.time;

import com.google.inject.Inject;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.event.PlayPauseActionEvent;
import tazadum.engine.ui.event.PlayPauseEvent;
import tazadum.engine.ui.event.TimeSkipActionEvent;
import tazadum.engine.util.event.EventBus;

public class TimeManagerImpl
implements TimeManager,
PlayPauseActionEvent.Handler {
    private static final double NSinv = 1.0E-9;
    private static final double NS = 1.0E9;
    private final EventBus eventBus;
    private boolean started = false;
    private long elapsedTime = 0L;
    private long startTime = 0L;
    private long frameTime;
    private long deltaTime;

    @Inject
    public TimeManagerImpl(EventBus eventBus) {
        this.eventBus = eventBus;
        eventBus.addHandler(PlayPauseActionEvent.TYPE, this);
        eventBus.addHandler(TimeSkipActionEvent.TYPE, new TimeSkipActionEvent.Handler(){

            @Override
            public void onTimeSkip(TimeSkipActionEvent timeSkipActionEvent) {
                if (timeSkipActionEvent.getAmount() == 0.0f) {
                    return;
                }
                float f = Math.max(0.0f, TimeManagerImpl.this.getTime() + timeSkipActionEvent.getAmount());
                TimeManagerImpl.this.setTime(f);
            }
        });
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.startTime = this.time();
    }

    @Override
    public boolean isPaused() {
        return !this.started;
    }

    @Override
    public void pause() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.elapsedTime += this.time() - this.startTime;
    }

    @Override
    public void reset() {
        this.started = false;
        this.elapsedTime = 0L;
    }

    @Override
    public float getTime() {
        if (!this.started) {
            return (float)((double)this.elapsedTime * 1.0E-9);
        }
        return (float)((double)(this.time() - this.startTime + this.elapsedTime) * 1.0E-9);
    }

    @Override
    public float getDeltaTime() {
        return (float)((double)this.deltaTime * 1.0E-9);
    }

    @Override
    public void frame() {
        long l = this.time();
        this.deltaTime = l - this.frameTime;
        this.frameTime = l;
    }

    @Override
    public void setTime(float f) {
        this.elapsedTime = !this.started ? (long)((double)f * 1.0E9) : (long)((double)f * 1.0E9) + this.startTime - this.time();
    }

    private long time() {
        return System.nanoTime();
    }

    @Override
    public void onPlayPause(PlayPauseActionEvent playPauseActionEvent) {
        switch (playPauseActionEvent.getAction()) {
            case Toggle: {
                if (this.started) {
                    this.pause();
                    this.eventBus.fireEvent(new PlayPauseEvent(PlayPauseEvent.Action.Pause));
                    break;
                }
                this.start();
                this.eventBus.fireEvent(new PlayPauseEvent(PlayPauseEvent.Action.Play));
                break;
            }
            case Pause: {
                this.pause();
                this.eventBus.fireEvent(new PlayPauseEvent(PlayPauseEvent.Action.Pause));
                break;
            }
            case Play: {
                this.start();
                this.eventBus.fireEvent(new PlayPauseEvent(PlayPauseEvent.Action.Play));
            }
        }
    }
}

