/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tazadum.engine.resource.selector.Selector;

public class FileSystemWalker {
    private static final Logger logger = Logger.getLogger(FileSystemWalker.class.getName());
    private final File basedir;

    public FileSystemWalker(String string) {
        this.basedir = new File(string);
        if (!this.basedir.exists()) {
            this.basedir.mkdirs();
        }
        logger.log(Level.FINE, "Creating FileSystemWalker for directory " + string);
    }

    public List<String> select(Selector selector) {
        return this.walk(this.basedir, selector, "");
    }

    private List<String> walk(File file, Selector selector, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                arrayList.addAll(this.walk(file2, selector, file2.getPath()));
                continue;
            }
            if (!selector.selects(string, file2.getName())) continue;
            arrayList.add(file2.getPath());
        }
        return arrayList;
    }
}

