/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.particle;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import tazadum.engine.rendering.LifeCycle;
import tazadum.engine.rendering.particle.ParticleSystem;

public class ParticleSystemImpl
implements ParticleSystem,
LifeCycle {
    private final int size;
    private final int particles;
    private IntBuffer positionBuffer;
    private IntBuffer velocityBuffer;
    private FloatBuffer vertexBuffer;
    private FloatBuffer textureBuffer;
    private final int[] textures;
    private final int[] framebuffers;

    public ParticleSystemImpl(GL gL, int n) {
        this.size = n;
        this.particles = n * n;
        this.textures = new int[2];
        this.framebuffers = new int[2];
    }

    @Override
    public void onInit(GL gL) {
        gL.glGenTextures(this.textures.length, this.textures, 0);
        gL.glGenFramebuffers(this.framebuffers.length, this.framebuffers, 0);
        this.positionBuffer = ByteBuffer.allocateDirect(this.particles * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.velocityBuffer = ByteBuffer.allocateDirect(this.particles * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.vertexBuffer = ByteBuffer.allocateDirect(48).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.vertexBuffer.put(new float[]{-1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f});
        this.vertexBuffer.rewind();
        this.textureBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureBuffer.put(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
        this.textureBuffer.rewind();
        for (int i = 0; i < this.textures.length; ++i) {
            int n = this.textures[i];
            gL.glBindTexture(3553, n);
            gL.glTexParameterf(3553, 10241, 9729.0f);
            gL.glTexParameterf(3553, 10240, 9729.0f);
            gL.glTexParameteri(3553, 10242, 33071);
            gL.glTexParameteri(3553, 10243, 33071);
            gL.glTexImage2D(3553, 0, 6407, this.size, this.size, 0, 6407, 5125, (long)n);
            int n2 = this.framebuffers[i];
            gL.glBindFramebuffer(36160, n2);
            gL.glFramebufferTexture2D(36160, 36064, 3553, n, 0);
            int n3 = gL.glCheckFramebufferStatus(36160);
            if (n3 == 36053) continue;
            throw new IllegalStateException("Couldn't bind framebuffer");
        }
    }

    @Override
    public void onDeinit(GL gL) {
        gL.glDeleteTextures(this.textures.length, this.textures, 0);
        gL.glDeleteFramebuffers(this.framebuffers.length, this.framebuffers, 0);
    }

    @Override
    public void process(GL gL) {
        gL.glViewport(0, 0, this.size, this.size);
        gL.glActiveTexture(33984);
        gL.glBindTexture(3553, this.textures[0]);
        gL.glActiveTexture(33985);
        gL.glBindTexture(3553, this.textures[1]);
        gL.glBindFramebuffer(36160, this.framebuffers[0]);
        gL.glDrawArrays(5, 0, 4);
        gL.glBindFramebuffer(36160, this.framebuffers[1]);
        gL.glDrawArrays(5, 0, 4);
        gL.glBindFramebuffer(36160, 0);
    }

    @Override
    public void draw(GL gL) {
        gL.glDrawArrays(0, 0, this.particles);
    }
}

