/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.mesh;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tazadum.engine.math.Box;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.memory.Buffers;
import tazadum.engine.rendering.mesh.Mesh;
import tazadum.engine.rendering.mesh.MeshImpl;

public class MeshBuilder {
    private final Map<Vector3f, Integer> vertices = new HashMap<Vector3f, Integer>();
    private final List<Integer> indices = new ArrayList<Integer>();
    private final List<Vector2f> coords = new ArrayList<Vector2f>();
    private final Box boundingBox = new Box();

    public void quad(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3, Vector2f vector2f4) {
        this.triangle(vector3f, vector3f2, vector3f4, vector2f, vector2f2, vector2f4);
        this.triangle(vector3f2, vector3f3, vector3f4, vector2f2, vector2f3, vector2f4);
    }

    public void quad(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        this.triangle(vector3f, vector3f2, vector3f4);
        this.triangle(vector3f2, vector3f3, vector3f4);
    }

    public void triangle(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3) {
        this.indices.add(this.vertex(vector3f, vector2f));
        this.indices.add(this.vertex(vector3f2, vector2f2));
        this.indices.add(this.vertex(vector3f3, vector2f3));
    }

    public void triangle(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.indices.add(this.vertex(vector3f));
        this.indices.add(this.vertex(vector3f2));
        this.indices.add(this.vertex(vector3f3));
    }

    public Mesh build() {
        FloatBuffer floatBuffer = Buffers.allocateFloat(3 * this.vertices.size());
        for (Map.Entry<Vector3f, Integer> iterator2 : this.vertices.entrySet()) {
            Vector3f vector3f = iterator2.getKey();
            int n = 3 * iterator2.getValue();
            floatBuffer.put(n + 0, vector3f.x);
            floatBuffer.put(n + 1, vector3f.y);
            floatBuffer.put(n + 2, vector3f.z);
        }
        floatBuffer.rewind();
        Object object = null;
        if (!this.coords.isEmpty()) {
            object = Buffers.allocateFloat(2 * this.coords.size());
            for (Vector2f vector2f : this.coords) {
                ((FloatBuffer)object).put(vector2f.x);
                ((FloatBuffer)object).put(vector2f.y);
            }
            ((FloatBuffer)object).rewind();
        }
        IntBuffer intBuffer = Buffers.allocateInt(this.indices.size());
        for (Integer n : this.indices) {
            intBuffer.put(n);
        }
        intBuffer.rewind();
        return new MeshImpl(floatBuffer, null, (FloatBuffer)object, intBuffer, this.boundingBox);
    }

    private int vertex(Vector3f vector3f, Vector2f vector2f) {
        if (!this.vertices.containsKey(vector3f)) {
            this.boundingBox.extend(vector3f);
            this.vertices.put(vector3f, this.vertices.size());
            this.coords.add(vector2f);
        }
        return this.vertices.get(vector3f);
    }

    private int vertex(Vector3f vector3f) {
        if (!this.vertices.containsKey(vector3f)) {
            this.boundingBox.extend(vector3f);
            this.vertices.put(vector3f, this.vertices.size());
        }
        return this.vertices.get(vector3f);
    }
}

