/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.material;

import com.jogamp.opengl.util.texture.Texture;
import tazadum.engine.asset.Asset;
import tazadum.engine.math.Vector4f;
import tazadum.engine.rendering.material.HasCullMode;
import tazadum.engine.rendering.material.Material;
import tazadum.engine.rendering.shader.MaterialShader;

public class DefaultMaterial
implements Material,
HasCullMode {
    private final MaterialShader shader;
    private Vector4f ambient = new Vector4f(0.1f, 0.1f, 0.1f, 1.0f);
    private Vector4f diffuse = new Vector4f(0.5f, 0.5f, 0.5f, 1.0f);
    private Vector4f specular = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private Asset<Texture> textureAsset = null;
    private float emittance = 0.0f;
    private boolean twoSides = false;
    private int priority = 10;

    public DefaultMaterial(MaterialShader materialShader) {
        this.shader = materialShader;
    }

    public void setEmittance(float f) {
        this.emittance = f;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    @Override
    public MaterialShader getShader() {
        return this.shader;
    }

    public Asset<Texture> getTextureAsset() {
        return this.textureAsset;
    }

    public void setTextureAsset(Asset<Texture> asset) {
        this.textureAsset = asset;
    }

    @Override
    public Vector4f getAmbient() {
        return this.ambient;
    }

    public void setAmbient(Vector4f vector4f) {
        this.ambient = vector4f;
    }

    @Override
    public Vector4f getDiffuse() {
        return this.diffuse;
    }

    public void setDiffuse(Vector4f vector4f) {
        this.diffuse = vector4f;
    }

    @Override
    public Vector4f getSpecular() {
        return this.specular;
    }

    public void setSpecular(Vector4f vector4f) {
        this.specular = vector4f;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.shader == null ? 0 : this.shader.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DefaultMaterial defaultMaterial = (DefaultMaterial)object;
        return !(this.shader == null ? defaultMaterial.shader != null : !this.shader.equals(defaultMaterial.shader));
    }

    @Override
    public float getEmittance() {
        return this.emittance;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public boolean isTwoSided() {
        return this.twoSides;
    }

    public void setTwoSided(boolean bl) {
        this.twoSides = bl;
    }
}

