/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering;

import javax.inject.Inject;
import tazadum.engine.math.Rectangle;
import tazadum.engine.math.Vector2f;
import tazadum.engine.rendering.layout.NormalizedLayout;

public class NormalizedLayoutImpl
implements NormalizedLayout {
    private final Rectangle area = new Rectangle(-1.0f, -1.0f, 2.0f, 2.0f);
    private float scaleX;
    private float scaleY;

    @Inject
    public NormalizedLayoutImpl() {
        this.set(this.area);
    }

    @Override
    public void set(Rectangle rectangle) {
        this.area.copy(rectangle);
        this.scaleX = this.area.width / 2.0f;
        this.scaleY = this.area.height / 2.0f;
    }

    @Override
    public Vector2f transform(Vector2f vector2f) {
        return new Vector2f(vector2f.x * this.scaleX - 1.0f, vector2f.y * this.scaleY - 1.0f);
    }

    @Override
    public void transformLocal(Vector2f vector2f) {
        vector2f.x = vector2f.x * this.scaleX - 1.0f;
        vector2f.y = vector2f.y * this.scaleY - 1.0f;
    }

    @Override
    public float horizontal(float f, float f2) {
        return f / this.area.width;
    }

    @Override
    public float vertical(float f, float f2) {
        return f / this.area.height;
    }
}

