/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class Buffers {
    public static final int SIZE_OF_FLOAT = 4;
    public static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_SHORT = 2;

    public static FloatBuffer allocateFloat(int n) {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(4 * n).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.rewind();
        return floatBuffer;
    }

    public static IntBuffer allocateInt(int n) {
        IntBuffer intBuffer = ByteBuffer.allocateDirect(4 * n).order(ByteOrder.nativeOrder()).asIntBuffer();
        intBuffer.rewind();
        return intBuffer;
    }

    public static ShortBuffer allocateShort(int n) {
        ShortBuffer shortBuffer = ByteBuffer.allocateDirect(2 * n).order(ByteOrder.nativeOrder()).asShortBuffer();
        shortBuffer.rewind();
        return shortBuffer;
    }

    public static ByteBuffer allocateByte(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.rewind();
        return byteBuffer;
    }
}

