/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math.tween;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.tween.PointType;
import tazadum.engine.math.tween.TweenPoint;

public class Tween {
    private static final Comparator<TweenPoint> POINT_COMPARATOR = new Comparator<TweenPoint>(){

        @Override
        public int compare(TweenPoint tweenPoint, TweenPoint tweenPoint2) {
            float f = tweenPoint.getPoint().x;
            float f2 = tweenPoint2.getPoint().x;
            return f < f2 ? -1 : (f == f2 ? 0 : 1);
        }
    };
    private final List<TweenPoint> points = new ArrayList<TweenPoint>();
    private transient Interval interval;
    private transient Interval range;
    private transient float firstValue;
    private transient float lastValue;
    private transient TweenPoint p0;
    private transient TweenPoint p1;

    public synchronized Collection<TweenPoint> getPoints() {
        return new ArrayList<TweenPoint>(this.points);
    }

    public synchronized void addPoint(TweenPoint tweenPoint) {
        this.points.add(tweenPoint);
        Collections.sort(this.points, POINT_COMPARATOR);
        this.updateInterval();
    }

    public synchronized void update() {
        Collections.sort(this.points, POINT_COMPARATOR);
        this.updateInterval();
    }

    public synchronized void removePoint(TweenPoint tweenPoint) {
        this.points.remove(tweenPoint);
    }

    public synchronized void updateInterval() {
        if (this.points.isEmpty()) {
            this.interval = new Interval(0.0f, 0.0f);
            this.range = new Interval(0.0f, 0.0f);
            return;
        }
        TweenPoint tweenPoint = this.points.get(0);
        TweenPoint tweenPoint2 = this.points.get(this.points.size() - 1);
        this.firstValue = tweenPoint.getPoint().y;
        this.lastValue = tweenPoint2.getPoint().y;
        if (this.interval == null) {
            this.interval = new Interval(tweenPoint.getPoint().x, tweenPoint2.getPoint().x);
            this.range = new Interval(0.0f, 0.0f);
        } else {
            this.interval.extend(tweenPoint.getPoint().x);
            this.interval.extend(tweenPoint2.getPoint().x);
        }
        for (TweenPoint tweenPoint3 : this.points) {
            this.range.extend(tweenPoint3.getPoint().y);
        }
    }

    public Interval getInterval() {
        if (this.interval == null) {
            this.updateInterval();
        }
        return this.interval;
    }

    public Interval getRange() {
        if (this.interval == null) {
            this.updateInterval();
        }
        return this.range;
    }

    public synchronized float get(float f) {
        if (this.points.isEmpty()) {
            return 0.0f;
        }
        if (this.interval == null) {
            this.updateInterval();
        }
        if (this.interval.isBefore(f)) {
            return this.firstValue;
        }
        if (this.interval.to() <= f) {
            return this.lastValue;
        }
        return this.interpolateValue(f);
    }

    private synchronized float interpolateValue(float f) {
        Object object;
        if (this.p0 == null || this.p1 == null || f < this.p0.getPoint().x || f > this.p1.getPoint().x) {
            object = this.points.iterator();
            this.p0 = null;
            while (object.hasNext()) {
                this.p1 = object.next();
                if (this.p1.getPoint().x > f) break;
                this.p0 = this.p1;
            }
        }
        if (this.p0 == null || this.p1 == null) {
            return this.firstValue;
        }
        object = this.p0.getPoint();
        Vector2f vector2f = this.p1.getPoint();
        float f2 = vector2f.x - ((Vector2f)object).x;
        if (f2 == 0.0f) {
            return vector2f.y;
        }
        if (this.p0.getType() == PointType.Curve && this.p1.getType() != PointType.Curve) {
            float f3 = (f - ((Vector2f)object).x) / f2;
            return this.interpolateCurve(f3, (Vector2f)object, this.p0.getRight(), this.p1.getLeft(), vector2f, PointType.Curve, PointType.Step);
        }
        switch (this.p1.getType()) {
            default: {
                return ((Vector2f)object).y;
            }
            case Interpolation: {
                float f4 = (f - ((Vector2f)object).x) / f2;
                return f4 * (vector2f.y - ((Vector2f)object).y) + ((Vector2f)object).y;
            }
            case Curve: 
        }
        float f5 = (f - ((Vector2f)object).x) / f2;
        return this.interpolateCurve(f5, (Vector2f)object, this.p0.getRight(), this.p1.getLeft(), vector2f, this.p0.getType(), this.p1.getType());
    }

    private float interpolateCurve(float f, Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3, Vector2f vector2f4, PointType pointType, PointType pointType2) {
        float f2 = pointType == PointType.Curve ? vector2f.y + vector2f2.y : vector2f.y + 0.1f;
        float f3 = pointType2 == PointType.Curve ? vector2f4.y + vector2f3.y : vector2f4.y - 0.1f;
        return this.segment(f, vector2f.y, f2, f3, vector2f4.y);
    }

    private float segment(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f - f;
        float f7 = f * f;
        float f8 = f6 * f6;
        float f9 = 3.0f * f8 * f;
        float f10 = 3.0f * f6 * f7;
        float f11 = f8 * f6;
        float f12 = f7 * f;
        return f11 * f2 + f9 * f3 + f10 * f4 + f12 * f5;
    }
}

