/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;
import tazadum.engine.math.FastMath;
import tazadum.engine.math.Vector3f;

public final class Vector2f {
    private static final Logger logger = Logger.getLogger(Vector2f.class.getName());
    public static final Vector2f ZERO = new Vector2f(0.0f, 0.0f);
    public static final Vector2f UNIT_XY = new Vector2f(1.0f, 1.0f);
    public float x;
    public float y;

    public Vector2f(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Vector2f() {
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector2f(Vector2f vector2f) {
        this.x = vector2f.x;
        this.y = vector2f.y;
    }

    public Vector2f set(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Vector2f set(Vector2f vector2f) {
        this.x = vector2f.x;
        this.y = vector2f.y;
        return this;
    }

    public Vector2f add(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return new Vector2f(this.x + vector2f.x, this.y + vector2f.y);
    }

    public Vector2f addLocal(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x += vector2f.x;
        this.y += vector2f.y;
        return this;
    }

    public Vector2f addLocal(float f, float f2) {
        this.x += f;
        this.y += f2;
        return this;
    }

    public Vector2f add(Vector2f vector2f, Vector2f vector2f2) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        if (vector2f2 == null) {
            vector2f2 = new Vector2f();
        }
        vector2f2.x = this.x + vector2f.x;
        vector2f2.y = this.y + vector2f.y;
        return vector2f2;
    }

    public float dot(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, 0 returned.");
            return 0.0f;
        }
        return this.x * vector2f.x + this.y * vector2f.y;
    }

    public Vector3f cross(Vector2f vector2f) {
        return new Vector3f(0.0f, 0.0f, this.determinant(vector2f));
    }

    public float determinant(Vector2f vector2f) {
        return this.x * vector2f.y - this.y * vector2f.x;
    }

    public Vector2f interpolate(Vector2f vector2f, float f) {
        this.x = (1.0f - f) * this.x + f * vector2f.x;
        this.y = (1.0f - f) * this.y + f * vector2f.y;
        return this;
    }

    public Vector2f interpolate(Vector2f vector2f, Vector2f vector2f2, float f) {
        this.x = (1.0f - f) * vector2f.x + f * vector2f2.x;
        this.y = (1.0f - f) * vector2f.y + f * vector2f2.y;
        return this;
    }

    public static boolean isValidVector(Vector2f vector2f) {
        if (vector2f == null) {
            return false;
        }
        if (Float.isNaN(vector2f.x) || Float.isNaN(vector2f.y)) {
            return false;
        }
        return !Float.isInfinite(vector2f.x) && !Float.isInfinite(vector2f.y);
    }

    public float length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distanceSquared(Vector2f vector2f) {
        double d = this.x - vector2f.x;
        double d2 = this.y - vector2f.y;
        return (float)(d * d + d2 * d2);
    }

    public float distanceSquared(float f, float f2) {
        double d = this.x - f;
        double d2 = this.y - f2;
        return (float)(d * d + d2 * d2);
    }

    public float distance(Vector2f vector2f) {
        return FastMath.sqrt(this.distanceSquared(vector2f));
    }

    public Vector2f mult(float f) {
        return new Vector2f(this.x * f, this.y * f);
    }

    public Vector2f multLocal(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public Vector2f multLocal(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x *= vector2f.x;
        this.y *= vector2f.y;
        return this;
    }

    public Vector2f mult(float f, Vector2f vector2f) {
        if (null == vector2f) {
            vector2f = new Vector2f();
        }
        vector2f.x = this.x * f;
        vector2f.y = this.y * f;
        return vector2f;
    }

    public Vector2f divide(float f) {
        return new Vector2f(this.x / f, this.y / f);
    }

    public Vector2f divideLocal(float f) {
        this.x /= f;
        this.y /= f;
        return this;
    }

    public Vector2f negate() {
        return new Vector2f(-this.x, -this.y);
    }

    public Vector2f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f subtract(Vector2f vector2f) {
        return this.subtract(vector2f, null);
    }

    public Vector2f subtract(Vector2f vector2f, Vector2f vector2f2) {
        if (vector2f2 == null) {
            vector2f2 = new Vector2f();
        }
        vector2f2.x = this.x - vector2f.x;
        vector2f2.y = this.y - vector2f.y;
        return vector2f2;
    }

    public Vector2f subtract(float f, float f2) {
        return new Vector2f(this.x - f, this.y - f2);
    }

    public Vector2f subtractLocal(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x -= vector2f.x;
        this.y -= vector2f.y;
        return this;
    }

    public Vector2f subtractLocal(float f, float f2) {
        this.x -= f;
        this.y -= f2;
        return this;
    }

    public Vector2f normalize() {
        float f = this.length();
        if (f != 0.0f) {
            return this.divide(f);
        }
        return this.divide(1.0f);
    }

    public Vector2f normalizeLocal() {
        float f = this.length();
        if (f != 0.0f) {
            return this.divideLocal(f);
        }
        return this.divideLocal(1.0f);
    }

    public float smallestAngleBetween(Vector2f vector2f) {
        float f = this.dot(vector2f);
        float f2 = FastMath.acos(f);
        return f2;
    }

    public float angleBetween(Vector2f vector2f) {
        float f = FastMath.atan2(vector2f.y, vector2f.x) - FastMath.atan2(this.y, this.x);
        return f;
    }

    public float getX() {
        return this.x;
    }

    public Vector2f setX(float f) {
        this.x = f;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Vector2f setY(float f) {
        this.y = f;
        return this;
    }

    public float getAngle() {
        return FastMath.atan2(this.y, this.x);
    }

    public Vector2f zero() {
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    public int hashCode() {
        int n = 37;
        n += 37 * n + Float.floatToIntBits(this.x);
        n += 37 * n + Float.floatToIntBits(this.y);
        return n;
    }

    public Vector2f clone() {
        try {
            return (Vector2f)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public float[] toArray(float[] fArray) {
        if (fArray == null) {
            fArray = new float[]{this.x, this.y};
        }
        return fArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector2f)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Vector2f vector2f = (Vector2f)object;
        if (Float.compare(this.x, vector2f.x) != 0) {
            return false;
        }
        return Float.compare(this.y, vector2f.y) == 0;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
    }

    public void rotateAroundOrigin(float f, boolean bl) {
        if (bl) {
            f = -f;
        }
        float f2 = FastMath.cos(f) * this.x - FastMath.sin(f) * this.y;
        float f3 = FastMath.sin(f) * this.x + FastMath.cos(f) * this.y;
        this.x = f2;
        this.y = f3;
    }
}

