/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import tazadum.engine.math.Quaternion;
import tazadum.engine.math.Vector3f;

public final class Transform {
    public static final Transform Identity = new Transform();
    private Quaternion rot = new Quaternion();
    private Vector3f translation = new Vector3f();
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);

    public Transform(Vector3f vector3f, Quaternion quaternion) {
        this.translation.set(vector3f);
        this.rot.set(quaternion);
    }

    public Transform(Vector3f vector3f) {
        this(vector3f, Quaternion.IDENTITY);
    }

    public Transform(Quaternion quaternion) {
        this(Vector3f.ZERO, quaternion);
    }

    public Transform() {
        this(Vector3f.ZERO, Quaternion.IDENTITY);
    }

    public Transform setRotation(Quaternion quaternion) {
        this.rot.set(quaternion);
        return this;
    }

    public Transform setTranslation(Vector3f vector3f) {
        this.translation.set(vector3f);
        return this;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public Transform setScale(Vector3f vector3f) {
        this.scale.set(vector3f);
        return this;
    }

    public Transform setScale(float f) {
        this.scale.set(f, f, f);
        return this;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public Vector3f getTranslation(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        vector3f.set(this.translation);
        return vector3f;
    }

    public Quaternion getRotation(Quaternion quaternion) {
        if (quaternion == null) {
            quaternion = new Quaternion();
        }
        quaternion.set(this.rot);
        return quaternion;
    }

    public Quaternion getRotation() {
        return this.rot;
    }

    public Vector3f getScale(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        vector3f.set(this.scale);
        return vector3f;
    }

    public void interpolateTransforms(Transform transform, Transform transform2, float f) {
        this.rot.slerp(transform.rot, transform2.rot, f);
        this.translation.interpolate(transform.translation, transform2.translation, f);
        this.scale.interpolate(transform.scale, transform2.scale, f);
    }

    public Transform combineWithParent(Transform transform) {
        this.scale.multLocal(transform.scale);
        transform.rot.mult(this.rot, this.rot);
        transform.rot.multLocal(this.translation).multLocal(transform.scale).addLocal(transform.translation);
        return this;
    }

    public Transform setTranslation(float f, float f2, float f3) {
        this.translation.set(f, f2, f3);
        return this;
    }

    public Transform setScale(float f, float f2, float f3) {
        this.scale.set(f, f2, f3);
        return this;
    }

    public Vector3f transformVector(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        return this.rot.mult(vector3f2.set(vector3f).multLocal(this.scale), vector3f2).addLocal(this.translation);
    }

    public Vector3f transformInverseVector(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        vector3f.subtract(this.translation, vector3f2).divideLocal(this.scale);
        this.rot.inverse().mult(vector3f2, vector3f2);
        return vector3f2;
    }

    public void loadIdentity() {
        this.translation.set(0.0f, 0.0f, 0.0f);
        this.scale.set(1.0f, 1.0f, 1.0f);
        this.rot.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + this.translation.x + ", " + this.translation.y + ", " + this.translation.z + "]\n" + "[ " + this.rot.x + ", " + this.rot.y + ", " + this.rot.z + ", " + this.rot.w + "]";
    }

    public Transform set(Transform transform) {
        this.translation.set(transform.translation);
        this.rot.set(transform.rot);
        this.scale.set(transform.scale);
        return this;
    }

    public Transform clone() {
        try {
            Transform transform = (Transform)super.clone();
            transform.rot = this.rot.clone();
            transform.scale = this.scale.clone();
            transform.translation = this.translation.clone();
            return transform;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }
}

