/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import tazadum.engine.math.Matrix4f;

public class MatrixStack {
    private static final int STACK_SIZE = 16;
    private final Matrix4f[] stack = new Matrix4f[16];
    private int index = 0;

    public MatrixStack() {
        for (int i = 0; i < 16; ++i) {
            this.stack[i] = new Matrix4f();
        }
    }

    public MatrixStack(Matrix4f matrix4f) {
        this();
        this.stack[0].copy(matrix4f);
    }

    public Matrix4f peek() {
        return this.stack[this.index];
    }

    public Matrix4f pop() {
        if (this.index == 0) {
            throw new IllegalStateException("Matrix stack exhausted");
        }
        return this.stack[this.index--];
    }

    public Matrix4f push() {
        if (this.index >= 15) {
            throw new IllegalStateException("Matrix stack overflow");
        }
        ++this.index;
        this.stack[this.index].copy(this.stack[this.index - 1]);
        return this.stack[this.index];
    }
}

