/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import java.nio.FloatBuffer;
import java.util.logging.Logger;
import tazadum.engine.math.BufferUtils;
import tazadum.engine.math.FastMath;
import tazadum.engine.math.Quaternion;
import tazadum.engine.math.Vector3f;

public final class Matrix3f {
    private static final Logger logger = Logger.getLogger(Matrix3f.class.getName());
    protected float m00;
    protected float m01;
    protected float m02;
    protected float m10;
    protected float m11;
    protected float m12;
    protected float m20;
    protected float m21;
    protected float m22;
    public static final Matrix3f ZERO = new Matrix3f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix3f IDENTITY = new Matrix3f();

    public Matrix3f() {
        this.loadIdentity();
    }

    public Matrix3f(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
        this.m20 = f7;
        this.m21 = f8;
        this.m22 = f9;
    }

    public Matrix3f(Matrix3f matrix3f) {
        this.set(matrix3f);
    }

    public void absoluteLocal() {
        this.m00 = FastMath.abs(this.m00);
        this.m01 = FastMath.abs(this.m01);
        this.m02 = FastMath.abs(this.m02);
        this.m10 = FastMath.abs(this.m10);
        this.m11 = FastMath.abs(this.m11);
        this.m12 = FastMath.abs(this.m12);
        this.m20 = FastMath.abs(this.m20);
        this.m21 = FastMath.abs(this.m21);
        this.m22 = FastMath.abs(this.m22);
    }

    public Matrix3f set(Matrix3f matrix3f) {
        if (null == matrix3f) {
            this.loadIdentity();
        } else {
            this.m00 = matrix3f.m00;
            this.m01 = matrix3f.m01;
            this.m02 = matrix3f.m02;
            this.m10 = matrix3f.m10;
            this.m11 = matrix3f.m11;
            this.m12 = matrix3f.m12;
            this.m20 = matrix3f.m20;
            this.m21 = matrix3f.m21;
            this.m22 = matrix3f.m22;
        }
        return this;
    }

    public float get(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public void get(float[] fArray, boolean bl) {
        if (fArray.length == 9) {
            if (bl) {
                fArray[0] = this.m00;
                fArray[1] = this.m01;
                fArray[2] = this.m02;
                fArray[3] = this.m10;
                fArray[4] = this.m11;
                fArray[5] = this.m12;
                fArray[6] = this.m20;
                fArray[7] = this.m21;
                fArray[8] = this.m22;
            } else {
                fArray[0] = this.m00;
                fArray[1] = this.m10;
                fArray[2] = this.m20;
                fArray[3] = this.m01;
                fArray[4] = this.m11;
                fArray[5] = this.m21;
                fArray[6] = this.m02;
                fArray[7] = this.m12;
                fArray[8] = this.m22;
            }
        } else if (fArray.length == 16) {
            if (bl) {
                fArray[0] = this.m00;
                fArray[1] = this.m01;
                fArray[2] = this.m02;
                fArray[4] = this.m10;
                fArray[5] = this.m11;
                fArray[6] = this.m12;
                fArray[8] = this.m20;
                fArray[9] = this.m21;
                fArray[10] = this.m22;
            } else {
                fArray[0] = this.m00;
                fArray[1] = this.m10;
                fArray[2] = this.m20;
                fArray[4] = this.m01;
                fArray[5] = this.m11;
                fArray[6] = this.m21;
                fArray[8] = this.m02;
                fArray[9] = this.m12;
                fArray[10] = this.m22;
            }
        } else {
            throw new IndexOutOfBoundsException("Array size must be 9 or 16 in Matrix3f.get().");
        }
    }

    public Vector3f getColumn(int n) {
        return this.getColumn(n, null);
    }

    public Vector3f getColumn(int n, Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        switch (n) {
            case 0: {
                vector3f.x = this.m00;
                vector3f.y = this.m10;
                vector3f.z = this.m20;
                break;
            }
            case 1: {
                vector3f.x = this.m01;
                vector3f.y = this.m11;
                vector3f.z = this.m21;
                break;
            }
            case 2: {
                vector3f.x = this.m02;
                vector3f.y = this.m12;
                vector3f.z = this.m22;
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new IllegalArgumentException("Invalid column index. " + n);
            }
        }
        return vector3f;
    }

    public Vector3f getRow(int n) {
        return this.getRow(n, null);
    }

    public Vector3f getRow(int n, Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        switch (n) {
            case 0: {
                vector3f.x = this.m00;
                vector3f.y = this.m01;
                vector3f.z = this.m02;
                break;
            }
            case 1: {
                vector3f.x = this.m10;
                vector3f.y = this.m11;
                vector3f.z = this.m12;
                break;
            }
            case 2: {
                vector3f.x = this.m20;
                vector3f.y = this.m21;
                vector3f.z = this.m22;
                break;
            }
            default: {
                logger.warning("Invalid row index.");
                throw new IllegalArgumentException("Invalid row index. " + n);
            }
        }
        return vector3f;
    }

    public FloatBuffer toFloatBuffer() {
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(9);
        floatBuffer.put(this.m00).put(this.m01).put(this.m02);
        floatBuffer.put(this.m10).put(this.m11).put(this.m12);
        floatBuffer.put(this.m20).put(this.m21).put(this.m22);
        floatBuffer.rewind();
        return floatBuffer;
    }

    public FloatBuffer fillFloatBuffer(FloatBuffer floatBuffer, boolean bl) {
        if (bl) {
            floatBuffer.put(this.m00).put(this.m10).put(this.m20);
            floatBuffer.put(this.m01).put(this.m11).put(this.m21);
            floatBuffer.put(this.m02).put(this.m12).put(this.m22);
        } else {
            floatBuffer.put(this.m00).put(this.m01).put(this.m02);
            floatBuffer.put(this.m10).put(this.m11).put(this.m12);
            floatBuffer.put(this.m20).put(this.m21).put(this.m22);
        }
        return floatBuffer;
    }

    public Matrix3f setColumn(int n, Vector3f vector3f) {
        if (vector3f == null) {
            logger.warning("Column is null. Ignoring.");
            return this;
        }
        switch (n) {
            case 0: {
                this.m00 = vector3f.x;
                this.m10 = vector3f.y;
                this.m20 = vector3f.z;
                break;
            }
            case 1: {
                this.m01 = vector3f.x;
                this.m11 = vector3f.y;
                this.m21 = vector3f.z;
                break;
            }
            case 2: {
                this.m02 = vector3f.x;
                this.m12 = vector3f.y;
                this.m22 = vector3f.z;
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new IllegalArgumentException("Invalid column index. " + n);
            }
        }
        return this;
    }

    public Matrix3f setRow(int n, Vector3f vector3f) {
        if (vector3f == null) {
            logger.warning("Row is null. Ignoring.");
            return this;
        }
        switch (n) {
            case 0: {
                this.m00 = vector3f.x;
                this.m01 = vector3f.y;
                this.m02 = vector3f.z;
                break;
            }
            case 1: {
                this.m10 = vector3f.x;
                this.m11 = vector3f.y;
                this.m12 = vector3f.z;
                break;
            }
            case 2: {
                this.m20 = vector3f.x;
                this.m21 = vector3f.y;
                this.m22 = vector3f.z;
                break;
            }
            default: {
                logger.warning("Invalid row index.");
                throw new IllegalArgumentException("Invalid row index. " + n);
            }
        }
        return this;
    }

    public Matrix3f set(int n, int n2, float f) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = f;
                        return this;
                    }
                    case 1: {
                        this.m01 = f;
                        return this;
                    }
                    case 2: {
                        this.m02 = f;
                        return this;
                    }
                }
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = f;
                        return this;
                    }
                    case 1: {
                        this.m11 = f;
                        return this;
                    }
                    case 2: {
                        this.m12 = f;
                        return this;
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        this.m20 = f;
                        return this;
                    }
                    case 1: {
                        this.m21 = f;
                        return this;
                    }
                    case 2: {
                        this.m22 = f;
                        return this;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public Matrix3f set(float[][] fArray) {
        if (fArray.length != 3 || fArray[0].length != 3) {
            throw new IllegalArgumentException("Array must be of size 9.");
        }
        this.m00 = fArray[0][0];
        this.m01 = fArray[0][1];
        this.m02 = fArray[0][2];
        this.m10 = fArray[1][0];
        this.m11 = fArray[1][1];
        this.m12 = fArray[1][2];
        this.m20 = fArray[2][0];
        this.m21 = fArray[2][1];
        this.m22 = fArray[2][2];
        return this;
    }

    public void fromAxes(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.m00 = vector3f.x;
        this.m10 = vector3f.y;
        this.m20 = vector3f.z;
        this.m01 = vector3f2.x;
        this.m11 = vector3f2.y;
        this.m21 = vector3f2.z;
        this.m02 = vector3f3.x;
        this.m12 = vector3f3.y;
        this.m22 = vector3f3.z;
    }

    public Matrix3f set(float[] fArray) {
        return this.set(fArray, true);
    }

    public Matrix3f set(float[] fArray, boolean bl) {
        if (fArray.length != 9) {
            throw new IllegalArgumentException("Array must be of size 9.");
        }
        if (bl) {
            this.m00 = fArray[0];
            this.m01 = fArray[1];
            this.m02 = fArray[2];
            this.m10 = fArray[3];
            this.m11 = fArray[4];
            this.m12 = fArray[5];
            this.m20 = fArray[6];
            this.m21 = fArray[7];
            this.m22 = fArray[8];
        } else {
            this.m00 = fArray[0];
            this.m01 = fArray[3];
            this.m02 = fArray[6];
            this.m10 = fArray[1];
            this.m11 = fArray[4];
            this.m12 = fArray[7];
            this.m20 = fArray[2];
            this.m21 = fArray[5];
            this.m22 = fArray[8];
        }
        return this;
    }

    public Matrix3f set(Quaternion quaternion) {
        return quaternion.toRotationMatrix(this);
    }

    public void loadIdentity() {
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f;
    }

    public void fromAngleAxis(float f, Vector3f vector3f) {
        Vector3f vector3f2 = vector3f.normalize();
        this.fromAngleNormalAxis(f, vector3f2);
    }

    public void fromAngleNormalAxis(float f, Vector3f vector3f) {
        float f2 = FastMath.cos(f);
        float f3 = FastMath.sin(f);
        float f4 = 1.0f - f2;
        float f5 = vector3f.x * vector3f.x;
        float f6 = vector3f.y * vector3f.y;
        float f7 = vector3f.z * vector3f.z;
        float f8 = vector3f.x * vector3f.y * f4;
        float f9 = vector3f.x * vector3f.z * f4;
        float f10 = vector3f.y * vector3f.z * f4;
        float f11 = vector3f.x * f3;
        float f12 = vector3f.y * f3;
        float f13 = vector3f.z * f3;
        this.m00 = f5 * f4 + f2;
        this.m01 = f8 - f13;
        this.m02 = f9 + f12;
        this.m10 = f8 + f13;
        this.m11 = f6 * f4 + f2;
        this.m12 = f10 - f11;
        this.m20 = f9 - f12;
        this.m21 = f10 + f11;
        this.m22 = f7 * f4 + f2;
    }

    public Matrix3f mult(Matrix3f matrix3f) {
        return this.mult(matrix3f, null);
    }

    public Matrix3f mult(Matrix3f matrix3f, Matrix3f matrix3f2) {
        if (matrix3f2 == null) {
            matrix3f2 = new Matrix3f();
        }
        float f = this.m00 * matrix3f.m00 + this.m01 * matrix3f.m10 + this.m02 * matrix3f.m20;
        float f2 = this.m00 * matrix3f.m01 + this.m01 * matrix3f.m11 + this.m02 * matrix3f.m21;
        float f3 = this.m00 * matrix3f.m02 + this.m01 * matrix3f.m12 + this.m02 * matrix3f.m22;
        float f4 = this.m10 * matrix3f.m00 + this.m11 * matrix3f.m10 + this.m12 * matrix3f.m20;
        float f5 = this.m10 * matrix3f.m01 + this.m11 * matrix3f.m11 + this.m12 * matrix3f.m21;
        float f6 = this.m10 * matrix3f.m02 + this.m11 * matrix3f.m12 + this.m12 * matrix3f.m22;
        float f7 = this.m20 * matrix3f.m00 + this.m21 * matrix3f.m10 + this.m22 * matrix3f.m20;
        float f8 = this.m20 * matrix3f.m01 + this.m21 * matrix3f.m11 + this.m22 * matrix3f.m21;
        float f9 = this.m20 * matrix3f.m02 + this.m21 * matrix3f.m12 + this.m22 * matrix3f.m22;
        matrix3f2.m00 = f;
        matrix3f2.m01 = f2;
        matrix3f2.m02 = f3;
        matrix3f2.m10 = f4;
        matrix3f2.m11 = f5;
        matrix3f2.m12 = f6;
        matrix3f2.m20 = f7;
        matrix3f2.m21 = f8;
        matrix3f2.m22 = f9;
        return matrix3f2;
    }

    public Vector3f mult(Vector3f vector3f) {
        return this.mult(vector3f, null);
    }

    public Vector3f mult(Vector3f vector3f, Vector3f vector3f2) {
        if (null == vector3f2) {
            vector3f2 = new Vector3f();
        }
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f2.x = this.m00 * f + this.m01 * f2 + this.m02 * f3;
        vector3f2.y = this.m10 * f + this.m11 * f2 + this.m12 * f3;
        vector3f2.z = this.m20 * f + this.m21 * f2 + this.m22 * f3;
        return vector3f2;
    }

    public Matrix3f multLocal(float f) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m10 *= f;
        this.m11 *= f;
        this.m12 *= f;
        this.m20 *= f;
        this.m21 *= f;
        this.m22 *= f;
        return this;
    }

    public Vector3f multLocal(Vector3f vector3f) {
        if (vector3f == null) {
            return null;
        }
        float f = vector3f.x;
        float f2 = vector3f.y;
        vector3f.x = this.m00 * f + this.m01 * f2 + this.m02 * vector3f.z;
        vector3f.y = this.m10 * f + this.m11 * f2 + this.m12 * vector3f.z;
        vector3f.z = this.m20 * f + this.m21 * f2 + this.m22 * vector3f.z;
        return vector3f;
    }

    public Matrix3f multLocal(Matrix3f matrix3f) {
        return this.mult(matrix3f, this);
    }

    public Matrix3f transposeLocal() {
        float f = this.m01;
        this.m01 = this.m10;
        this.m10 = f;
        f = this.m02;
        this.m02 = this.m20;
        this.m20 = f;
        f = this.m12;
        this.m12 = this.m21;
        this.m21 = f;
        return this;
    }

    public Matrix3f invert() {
        return this.invert(null);
    }

    public Matrix3f invert(Matrix3f matrix3f) {
        float f;
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        if (FastMath.abs(f = this.determinant()) <= 1.1920929E-7f) {
            return matrix3f.zero();
        }
        matrix3f.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        matrix3f.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        matrix3f.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3f.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        matrix3f.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        matrix3f.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3f.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        matrix3f.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        matrix3f.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        matrix3f.multLocal(1.0f / f);
        return matrix3f;
    }

    public Matrix3f invertLocal() {
        float f = this.determinant();
        if (FastMath.abs(f) <= 1.1920929E-7f) {
            return this.zero();
        }
        float f2 = this.m11 * this.m22 - this.m12 * this.m21;
        float f3 = this.m02 * this.m21 - this.m01 * this.m22;
        float f4 = this.m01 * this.m12 - this.m02 * this.m11;
        float f5 = this.m12 * this.m20 - this.m10 * this.m22;
        float f6 = this.m00 * this.m22 - this.m02 * this.m20;
        float f7 = this.m02 * this.m10 - this.m00 * this.m12;
        float f8 = this.m10 * this.m21 - this.m11 * this.m20;
        float f9 = this.m01 * this.m20 - this.m00 * this.m21;
        float f10 = this.m00 * this.m11 - this.m01 * this.m10;
        this.m00 = f2;
        this.m01 = f3;
        this.m02 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
        this.multLocal(1.0f / f);
        return this;
    }

    public Matrix3f adjoint() {
        return this.adjoint(null);
    }

    public Matrix3f adjoint(Matrix3f matrix3f) {
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        matrix3f.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        matrix3f.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        matrix3f.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3f.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        matrix3f.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        matrix3f.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3f.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        matrix3f.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        matrix3f.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        return matrix3f;
    }

    public float determinant() {
        float f = this.m11 * this.m22 - this.m12 * this.m21;
        float f2 = this.m12 * this.m20 - this.m10 * this.m22;
        float f3 = this.m10 * this.m21 - this.m11 * this.m20;
        float f4 = this.m00 * f + this.m01 * f2 + this.m02 * f3;
        return f4;
    }

    public Matrix3f zero() {
        this.m22 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m11 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m00 = 0.0f;
        return this;
    }

    @Deprecated
    public void add(Matrix3f matrix3f) {
        this.m00 += matrix3f.m00;
        this.m01 += matrix3f.m01;
        this.m02 += matrix3f.m02;
        this.m10 += matrix3f.m10;
        this.m11 += matrix3f.m11;
        this.m12 += matrix3f.m12;
        this.m20 += matrix3f.m20;
        this.m21 += matrix3f.m21;
        this.m22 += matrix3f.m22;
    }

    public Matrix3f transpose() {
        return this.transposeLocal();
    }

    public Matrix3f transposeNew() {
        Matrix3f matrix3f = new Matrix3f(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return matrix3f;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Matrix3f\n[\n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m00);
        stringBuffer.append("  ");
        stringBuffer.append(this.m01);
        stringBuffer.append("  ");
        stringBuffer.append(this.m02);
        stringBuffer.append(" \n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m10);
        stringBuffer.append("  ");
        stringBuffer.append(this.m11);
        stringBuffer.append("  ");
        stringBuffer.append(this.m12);
        stringBuffer.append(" \n");
        stringBuffer.append(" ");
        stringBuffer.append(this.m20);
        stringBuffer.append("  ");
        stringBuffer.append(this.m21);
        stringBuffer.append("  ");
        stringBuffer.append(this.m22);
        stringBuffer.append(" \n]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 37;
        n = 37 * n + Float.floatToIntBits(this.m00);
        n = 37 * n + Float.floatToIntBits(this.m01);
        n = 37 * n + Float.floatToIntBits(this.m02);
        n = 37 * n + Float.floatToIntBits(this.m10);
        n = 37 * n + Float.floatToIntBits(this.m11);
        n = 37 * n + Float.floatToIntBits(this.m12);
        n = 37 * n + Float.floatToIntBits(this.m20);
        n = 37 * n + Float.floatToIntBits(this.m21);
        n = 37 * n + Float.floatToIntBits(this.m22);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Matrix3f) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Matrix3f matrix3f = (Matrix3f)object;
        if (Float.compare(this.m00, matrix3f.m00) != 0) {
            return false;
        }
        if (Float.compare(this.m01, matrix3f.m01) != 0) {
            return false;
        }
        if (Float.compare(this.m02, matrix3f.m02) != 0) {
            return false;
        }
        if (Float.compare(this.m10, matrix3f.m10) != 0) {
            return false;
        }
        if (Float.compare(this.m11, matrix3f.m11) != 0) {
            return false;
        }
        if (Float.compare(this.m12, matrix3f.m12) != 0) {
            return false;
        }
        if (Float.compare(this.m20, matrix3f.m20) != 0) {
            return false;
        }
        if (Float.compare(this.m21, matrix3f.m21) != 0) {
            return false;
        }
        return Float.compare(this.m22, matrix3f.m22) == 0;
    }

    public void fromStartEndVectors(Vector3f vector3f, Vector3f vector3f2) {
        float f;
        Vector3f vector3f3 = new Vector3f();
        vector3f.cross(vector3f2, vector3f3);
        float f2 = vector3f.dot(vector3f2);
        float f3 = f = f2 < 0.0f ? -f2 : f2;
        if (f > 0.9999f) {
            Vector3f vector3f4 = new Vector3f();
            Vector3f vector3f5 = new Vector3f();
            vector3f5.x = (double)vector3f.x > 0.0 ? vector3f.x : -vector3f.x;
            vector3f5.y = (double)vector3f.y > 0.0 ? vector3f.y : -vector3f.y;
            float f4 = vector3f5.z = (double)vector3f.z > 0.0 ? vector3f.z : -vector3f.z;
            if (vector3f5.x < vector3f5.y) {
                if (vector3f5.x < vector3f5.z) {
                    vector3f5.x = 1.0f;
                    vector3f5.z = 0.0f;
                    vector3f5.y = 0.0f;
                } else {
                    vector3f5.z = 1.0f;
                    vector3f5.y = 0.0f;
                    vector3f5.x = 0.0f;
                }
            } else if (vector3f5.y < vector3f5.z) {
                vector3f5.y = 1.0f;
                vector3f5.z = 0.0f;
                vector3f5.x = 0.0f;
            } else {
                vector3f5.z = 1.0f;
                vector3f5.y = 0.0f;
                vector3f5.x = 0.0f;
            }
            vector3f4.x = vector3f5.x - vector3f.x;
            vector3f4.y = vector3f5.y - vector3f.y;
            vector3f4.z = vector3f5.z - vector3f.z;
            vector3f3.x = vector3f5.x - vector3f2.x;
            vector3f3.y = vector3f5.y - vector3f2.y;
            vector3f3.z = vector3f5.z - vector3f2.z;
            float f5 = 2.0f / vector3f4.dot(vector3f4);
            float f6 = 2.0f / vector3f3.dot(vector3f3);
            float f7 = f5 * f6 * vector3f4.dot(vector3f3);
            for (int i = 0; i < 3; ++i) {
                float f8;
                for (int j = 0; j < 3; ++j) {
                    f8 = -f5 * vector3f4.get(i) * vector3f4.get(j) - f6 * vector3f3.get(i) * vector3f3.get(j) + f7 * vector3f3.get(i) * vector3f4.get(j);
                    this.set(i, j, f8);
                }
                f8 = this.get(i, i);
                this.set(i, i, f8 + 1.0f);
            }
        } else {
            float f9 = 1.0f / (1.0f + f2);
            float f10 = f9 * vector3f3.x;
            float f11 = f9 * vector3f3.z;
            float f12 = f10 * vector3f3.y;
            float f13 = f10 * vector3f3.z;
            float f14 = f11 * vector3f3.y;
            this.set(0, 0, f2 + f10 * vector3f3.x);
            this.set(0, 1, f12 - vector3f3.z);
            this.set(0, 2, f13 + vector3f3.y);
            this.set(1, 0, f12 + vector3f3.z);
            this.set(1, 1, f2 + f9 * vector3f3.y * vector3f3.y);
            this.set(1, 2, f14 - vector3f3.x);
            this.set(2, 0, f13 - vector3f3.y);
            this.set(2, 1, f14 + vector3f3.x);
            this.set(2, 2, f2 + f11 * vector3f3.z);
        }
    }

    public void scale(Vector3f vector3f) {
        this.m00 *= vector3f.x;
        this.m10 *= vector3f.x;
        this.m20 *= vector3f.x;
        this.m01 *= vector3f.y;
        this.m11 *= vector3f.y;
        this.m21 *= vector3f.y;
        this.m02 *= vector3f.z;
        this.m12 *= vector3f.z;
        this.m22 *= vector3f.z;
    }

    static final boolean equalIdentity(Matrix3f matrix3f) {
        if ((double)Math.abs(matrix3f.m00 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m11 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m22 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m01) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m02) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m10) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m12) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m20) > 1.0E-4) {
            return false;
        }
        return !((double)Math.abs(matrix3f.m21) > 1.0E-4);
    }

    public Matrix3f clone() {
        try {
            return (Matrix3f)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }
}

