/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import tazadum.engine.math.FastMath;

public final class ColorRGBA {
    public static final ColorRGBA Black = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorRGBA White = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public float r;
    public float g;
    public float b;
    public float a;

    public ColorRGBA() {
        this.a = 1.0f;
        this.b = 1.0f;
        this.g = 1.0f;
        this.r = 1.0f;
    }

    public ColorRGBA(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
    }

    public ColorRGBA(ColorRGBA colorRGBA) {
        this.a = colorRGBA.a;
        this.r = colorRGBA.r;
        this.g = colorRGBA.g;
        this.b = colorRGBA.b;
    }

    public ColorRGBA set(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
        return this;
    }

    public ColorRGBA set(ColorRGBA colorRGBA) {
        if (colorRGBA == null) {
            this.r = 0.0f;
            this.g = 0.0f;
            this.b = 0.0f;
            this.a = 0.0f;
        } else {
            this.r = colorRGBA.r;
            this.g = colorRGBA.g;
            this.b = colorRGBA.b;
            this.a = colorRGBA.a;
        }
        return this;
    }

    public void clamp() {
        if (this.r < 0.0f) {
            this.r = 0.0f;
        } else if (this.r > 1.0f) {
            this.r = 1.0f;
        }
        if (this.g < 0.0f) {
            this.g = 0.0f;
        } else if (this.g > 1.0f) {
            this.g = 1.0f;
        }
        if (this.b < 0.0f) {
            this.b = 0.0f;
        } else if (this.b > 1.0f) {
            this.b = 1.0f;
        }
        if (this.a < 0.0f) {
            this.a = 0.0f;
        } else if (this.a > 1.0f) {
            this.a = 1.0f;
        }
    }

    public float[] getColorArray() {
        return new float[]{this.r, this.g, this.b, this.a};
    }

    public float[] getColorArray(float[] fArray) {
        fArray[0] = this.r;
        fArray[1] = this.g;
        fArray[2] = this.b;
        fArray[3] = this.a;
        return fArray;
    }

    public float getAlpha() {
        return this.a;
    }

    public float getRed() {
        return this.r;
    }

    public float getBlue() {
        return this.b;
    }

    public float getGreen() {
        return this.g;
    }

    public void interpolate(ColorRGBA colorRGBA, float f) {
        this.r = (1.0f - f) * this.r + f * colorRGBA.r;
        this.g = (1.0f - f) * this.g + f * colorRGBA.g;
        this.b = (1.0f - f) * this.b + f * colorRGBA.b;
        this.a = (1.0f - f) * this.a + f * colorRGBA.a;
    }

    public void interpolate(ColorRGBA colorRGBA, ColorRGBA colorRGBA2, float f) {
        this.r = (1.0f - f) * colorRGBA.r + f * colorRGBA2.r;
        this.g = (1.0f - f) * colorRGBA.g + f * colorRGBA2.g;
        this.b = (1.0f - f) * colorRGBA.b + f * colorRGBA2.b;
        this.a = (1.0f - f) * colorRGBA.a + f * colorRGBA2.a;
    }

    public static ColorRGBA randomColor() {
        ColorRGBA colorRGBA = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        colorRGBA.r = FastMath.nextRandomFloat();
        colorRGBA.g = FastMath.nextRandomFloat();
        colorRGBA.b = FastMath.nextRandomFloat();
        return colorRGBA;
    }

    public ColorRGBA mult(ColorRGBA colorRGBA) {
        return new ColorRGBA(colorRGBA.r * this.r, colorRGBA.g * this.g, colorRGBA.b * this.b, colorRGBA.a * this.a);
    }

    public ColorRGBA mult(float f) {
        return new ColorRGBA(f * this.r, f * this.g, f * this.b, f * this.a);
    }

    public ColorRGBA multLocal(float f) {
        this.r *= f;
        this.g *= f;
        this.b *= f;
        this.a *= f;
        return this;
    }

    public ColorRGBA add(ColorRGBA colorRGBA) {
        return new ColorRGBA(colorRGBA.r + this.r, colorRGBA.g + this.g, colorRGBA.b + this.b, colorRGBA.a + this.a);
    }

    public ColorRGBA addLocal(ColorRGBA colorRGBA) {
        this.set(colorRGBA.r + this.r, colorRGBA.g + this.g, colorRGBA.b + this.b, colorRGBA.a + this.a);
        return this;
    }

    public String toString() {
        return "Color[" + this.r + ", " + this.g + ", " + this.b + ", " + this.a + "]";
    }

    public ColorRGBA clone() {
        try {
            return (ColorRGBA)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public float[] toArray(float[] fArray) {
        if (fArray == null) {
            fArray = new float[]{this.r, this.g, this.b, this.a};
        }
        return fArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorRGBA)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ColorRGBA colorRGBA = (ColorRGBA)object;
        if (Float.compare(this.r, colorRGBA.r) != 0) {
            return false;
        }
        if (Float.compare(this.g, colorRGBA.g) != 0) {
            return false;
        }
        if (Float.compare(this.b, colorRGBA.b) != 0) {
            return false;
        }
        return Float.compare(this.a, colorRGBA.a) == 0;
    }

    public int hashCode() {
        int n = 37;
        n += 37 * n + Float.floatToIntBits(this.r);
        n += 37 * n + Float.floatToIntBits(this.g);
        n += 37 * n + Float.floatToIntBits(this.b);
        n += 37 * n + Float.floatToIntBits(this.a);
        return n;
    }

    public byte[] asBytesRGBA() {
        byte[] byArray = new byte[]{(byte)((int)(this.r * 255.0f) & 0xFF), (byte)((int)(this.g * 255.0f) & 0xFF), (byte)((int)(this.b * 255.0f) & 0xFF), (byte)((int)(this.a * 255.0f) & 0xFF)};
        return byArray;
    }

    public int asIntARGB() {
        int n = ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.b * 255.0f) & 0xFF;
        return n;
    }

    public int asIntRGBA() {
        int n = ((int)(this.r * 255.0f) & 0xFF) << 24 | ((int)(this.g * 255.0f) & 0xFF) << 16 | ((int)(this.b * 255.0f) & 0xFF) << 8 | (int)(this.a * 255.0f) & 0xFF;
        return n;
    }

    public int asIntABGR() {
        int n = ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.b * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.r * 255.0f) & 0xFF;
        return n;
    }

    public void fromIntARGB(int n) {
        this.a = (float)((byte)(n >> 24) & 0xFF) / 255.0f;
        this.r = (float)((byte)(n >> 16) & 0xFF) / 255.0f;
        this.g = (float)((byte)(n >> 8) & 0xFF) / 255.0f;
        this.b = (float)((byte)n & 0xFF) / 255.0f;
    }

    public void fromIntRGBA(int n) {
        this.r = (float)((byte)(n >> 24) & 0xFF) / 255.0f;
        this.g = (float)((byte)(n >> 16) & 0xFF) / 255.0f;
        this.b = (float)((byte)(n >> 8) & 0xFF) / 255.0f;
        this.a = (float)((byte)n & 0xFF) / 255.0f;
    }
}

