/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.asset;

import tazadum.engine.asset.Asset;
import tazadum.engine.rendering.mesh.Mesh;
import tazadum.engine.resource.Loadable;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.resource.wavefront.WavefrontObject;
import tazadum.engine.resource.wavefront.WavefrontObjectBuilder;

public class MeshAsset
implements Asset<Mesh>,
Loadable {
    private final String filename;
    private Mesh mesh = null;

    public MeshAsset(String string) {
        this.filename = string;
    }

    @Override
    public Mesh get() {
        return this.mesh;
    }

    @Override
    public boolean isLoaded() {
        return this.mesh != null;
    }

    @Override
    public void load(ResourceManager resourceManager) throws Exception {
        byte[] byArray = resourceManager.load(this.filename);
        WavefrontObjectBuilder wavefrontObjectBuilder = new WavefrontObjectBuilder();
        wavefrontObjectBuilder.parse(new String(byArray));
        WavefrontObject wavefrontObject = wavefrontObjectBuilder.build();
        this.mesh = wavefrontObject.asMesh();
    }

    public String toString() {
        return "MeshAsset [filename=" + this.filename + "]";
    }
}

