/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.imageio.ImageIO;
import javax.media.opengl.GL2;
import tazadum.engine.memory.Buffers;

public class Recorder
implements Runnable {
    private final ByteBuffer buffer;
    private final BufferedImage image;
    private final File folder;
    private final int width;
    private final int height;
    private int frame = 0;
    private final BlockingQueue<ByteBuffer> queue = new ArrayBlockingQueue<ByteBuffer>(1);
    private final byte[] pixel;
    private final int[] pixelInts;
    private final Thread thread;

    public Recorder(File file, int n, int n2) {
        this.folder = file;
        this.width = n;
        this.height = n2;
        this.buffer = Buffers.allocateByte(n * n2 * 4);
        this.image = new BufferedImage(n, n2, 2);
        this.pixel = new byte[4 * n * n2];
        this.pixelInts = new int[n * n2];
        if (!file.exists()) {
            file.mkdirs();
        }
        this.thread = new Thread(this);
    }

    public void record(GL2 gL2) {
        gL2.glReadBuffer(1029);
        gL2.glPixelStorei(3333, 1);
        this.buffer.rewind();
        gL2.glReadPixels(0, 0, this.width, this.height, 6407, 5121, (Buffer)this.buffer);
        this.writeToPNGFile(this.buffer);
    }

    @Override
    public void run() {
        try {
            while (true) {
                ByteBuffer byteBuffer = this.queue.take();
                this.writeToFile(byteBuffer);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
    }

    private void writeToFile(ByteBuffer byteBuffer) {
        try {
            byteBuffer.rewind();
            byteBuffer.get(this.pixel, 0, this.pixel.length);
            File file = new File(this.folder, String.format("frame_%06d.raw", this.frame++));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.pixel, 0, this.pixel.length);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeToPNGFile(ByteBuffer byteBuffer) {
        int n = this.width * this.height * 3;
        int n2 = 0;
        int n3 = this.width * 3;
        for (int i = 0; i < this.height; ++i) {
            int n4 = n -= n3;
            for (int j = 0; j < this.width; ++j) {
                byte by = byteBuffer.get(n4++);
                byte by2 = byteBuffer.get(n4++);
                byte by3 = byteBuffer.get(n4++);
                this.pixelInts[n2++] = 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
            }
        }
        this.image.setRGB(0, 0, this.width, this.height, this.pixelInts, 0, this.width);
        try {
            File file = new File(this.folder, String.format("frame_%06d.png", this.frame++));
            ImageIO.write((RenderedImage)this.image, "PNG", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

