/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine;

import com.google.inject.Injector;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JFrame;
import tazadum.engine.DisplayModeSelector;
import tazadum.engine.Recorder;
import tazadum.engine.configuration.ConfigurationManager;
import tazadum.engine.configuration.TimelineManager;
import tazadum.engine.configuration.TimelineScene;
import tazadum.engine.integration.ExternalComponent;
import tazadum.engine.math.Interval;
import tazadum.engine.math.Rectangle;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.rendering.LifeCycleManager;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.CameraControl;
import tazadum.engine.ui.DebugFrame;
import tazadum.engine.ui.ParameterView;
import tazadum.engine.ui.TimelineLayerPanel;
import tazadum.engine.ui.event.PlayPauseActionEvent;
import tazadum.engine.ui.event.PlayPauseEvent;
import tazadum.engine.ui.event.TimeSkipActionEvent;
import tazadum.engine.ui.event.TimeTickEvent;
import tazadum.engine.util.event.EventBus;

public class Engine {
    private static final Logger logger = Logger.getLogger(Engine.class.getName());
    private final EventBus eventBus;
    private final TimeManager timeManager;
    private final TimelineManager timelineManager;
    private final ConfigurationManager configurationManager;
    private final Provider<DebugFrame> debugFameProvider;
    private final LifeCycleManager lifeCycleManager;
    private final RenderEngine renderEngine;
    private final CameraControl cameraControl;
    private final List<ExternalComponent> externalComponents = new ArrayList<ExternalComponent>();
    private final AtomicBoolean resourcesLoaded = new AtomicBoolean(false);
    private final AtomicBoolean initializationPerformed = new AtomicBoolean(false);
    private GLCanvas glcanvas;
    private Animator animator;
    private float debugAvgFps = 0.0f;
    private boolean debug;
    private boolean record = false;
    private Recorder recorder;

    @Inject
    public Engine(EventBus eventBus, TimeManager timeManager, TimelineManager timelineManager, ConfigurationManager configurationManager, Provider<DebugFrame> provider, RenderEngine renderEngine, LifeCycleManager lifeCycleManager, ParameterFactory parameterFactory, CameraControl cameraControl) {
        this.eventBus = eventBus;
        this.timeManager = timeManager;
        this.timelineManager = timelineManager;
        this.configurationManager = configurationManager;
        this.debugFameProvider = provider;
        this.renderEngine = renderEngine;
        this.lifeCycleManager = lifeCycleManager;
        this.cameraControl = cameraControl;
    }

    public void addExternalComponent(ExternalComponent externalComponent) {
        this.externalComponents.add(externalComponent);
    }

    public void configure(Injector injector, String string, String[] stringArray, float f, boolean bl) {
        this.debug = bl;
        this.configureLogging();
        this.configurationManager.load(injector, string, f);
    }

    private void configureLogging() {
        Logger logger = Logger.getLogger("");
        String string = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        String string2 = System.getProperty("logdir", "logs");
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string3 = string2 + "/engine_" + string + "_%u.log";
        try {
            for (Handler handler : logger.getHandlers()) {
                logger.removeHandler(handler);
            }
            FileHandler fileHandler = new FileHandler(string3, 524288000, 1, true);
            fileHandler.setFormatter(new SimpleFormatter());
            fileHandler.setLevel(Level.FINE);
            logger.addHandler(fileHandler);
            if (this.debug) {
                logger.addHandler(new StreamHandler(System.out, new SimpleFormatter()));
            }
            logger.setLevel(this.debug ? Level.INFO : Level.SEVERE);
        }
        catch (Exception exception) {
            Engine.logger.log(Level.SEVERE, "Can't setup logging", exception);
        }
    }

    public void initialize(final String string, int n, int n2, boolean bl) {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.glcanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        this.glcanvas.addGLEventListener((GLEventListener)new EngineGLEventListener());
        final Dimension dimension = new Dimension(n, n2);
        this.glcanvas.setSize(dimension);
        this.glcanvas.setMinimumSize(dimension);
        this.glcanvas.setMaximumSize(dimension);
        this.glcanvas.setPreferredSize(dimension);
        this.cameraControl.initialize(this.glcanvas, this.debug);
        if (this.debug) {
            final DebugFrame debugFrame = this.debugFameProvider.get();
            debugFrame.getFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    Engine.this.animator.stop();
                    debugFrame.getFrame().dispose();
                    System.exit(0);
                }
            });
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    debugFrame.setTitle(string);
                    debugFrame.getContentPanel().setSize(dimension);
                    debugFrame.getContentPanel().setMinimumSize(dimension);
                    debugFrame.getContentPanel().setMaximumSize(dimension);
                    debugFrame.getContentPanel().setPreferredSize(dimension);
                    debugFrame.getContentPanel().add((Component)Engine.this.glcanvas);
                    TimelineLayerPanel timelineLayerPanel = new TimelineLayerPanel(Engine.this.eventBus, Engine.this.timeManager, Engine.this.timelineManager);
                    debugFrame.getTimelinePanel().add((Component)timelineLayerPanel, "Center");
                    ParameterView parameterView = new ParameterView(Engine.this.eventBus, Engine.this.configurationManager);
                    debugFrame.getPropertyPanel().add((Component)parameterView, "Center");
                    JFrame jFrame = debugFrame.getFrame();
                    jFrame.setMinimumSize(dimension);
                    jFrame.setSize(new Dimension(dimension.width + 600, dimension.height + 500));
                    jFrame.setVisible(true);
                    Engine.this.setupKeyboardShortcuts();
                }
            });
            this.eventBus.addHandler(TimeSkipActionEvent.TYPE, new TimeSkipActionEvent.Handler(){

                @Override
                public void onTimeSkip(TimeSkipActionEvent timeSkipActionEvent) {
                    float f = Engine.this.timeManager.getTime();
                    for (ExternalComponent externalComponent : Engine.this.externalComponents) {
                        externalComponent.onSetTime(f);
                    }
                }
            });
            this.eventBus.addHandler(PlayPauseEvent.TYPE, new PlayPauseEvent.Handler(){

                @Override
                public void onPlayPause(PlayPauseEvent playPauseEvent) {
                    for (ExternalComponent externalComponent : Engine.this.externalComponents) {
                        switch (playPauseEvent.getAction()) {
                            case Play: {
                                externalComponent.onPlay();
                                break;
                            }
                            case Pause: {
                                externalComponent.onPause();
                                break;
                            }
                        }
                    }
                }
            });
        } else {
            Object object;
            JFrame jFrame = new JFrame(string);
            jFrame.getContentPane().add((Component)this.glcanvas);
            jFrame.setSize(dimension);
            jFrame.setResizable(false);
            jFrame.setUndecorated(true);
            if (bl) {
                object = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice graphicsDevice = ((GraphicsEnvironment)object).getDefaultScreenDevice();
                graphicsDevice.getDefaultConfiguration();
                jFrame.setUndecorated(true);
                graphicsDevice.setFullScreenWindow(jFrame);
                Dimension dimension2 = DisplayModeSelector.setDisplayMode(graphicsDevice, dimension.width, dimension.height);
                System.out.println("Display: " + dimension2);
            }
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            ((KeyboardFocusManager)object).addKeyEventDispatcher(new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (keyEvent.getID() != 401 && keyEvent.getKeyCode() == 27) {
                        Engine.this.animator.stop();
                        System.exit(0);
                    }
                    return false;
                }
            });
            jFrame.setVisible(true);
            jFrame.requestFocus();
            jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    Engine.this.animator.stop();
                    System.exit(0);
                }
            });
        }
    }

    private void setupKeyboardShortcuts() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() != 401) {
                    return false;
                }
                boolean bl = (keyEvent.getModifiersEx() & 0x80) != 0;
                boolean bl2 = (keyEvent.getModifiersEx() & 0x40) != 0;
                float f = (bl ? 10.0f : 1.0f) * (bl2 ? 0.1f : 1.0f);
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        Engine.this.eventBus.fireEvent(new TimeSkipActionEvent(-f));
                        return true;
                    }
                    case 39: {
                        Engine.this.eventBus.fireEvent(new TimeSkipActionEvent(f));
                        return true;
                    }
                    case 32: {
                        Engine.this.eventBus.fireEvent(new PlayPauseActionEvent(PlayPauseEvent.Action.Toggle));
                        return true;
                    }
                    case 9: {
                        Engine.this.cameraControl.toggleEditMode();
                    }
                }
                return false;
            }
        });
    }

    public void start() {
        this.startPreloader();
        if (this.debug) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(25L);
                            Engine.this.eventBus.fireEvent(new TimeTickEvent(Engine.this.timeManager.getTime(), Engine.this.debugAvgFps));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
            }, "UI-TickThread");
            thread.start();
        }
        this.timeManager.start();
        this.animator = new Animator((GLAutoDrawable)this.glcanvas);
        this.animator.setRunAsFastAsPossible(true);
        this.animator.start();
        try {
            this.animator.getThread().join();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Engine animator interrupted", exception);
        }
    }

    private void startPreloader() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.log(Level.INFO, "Preloading started");
                    for (TimelineScene object : Engine.this.timelineManager.getScenes()) {
                        object.getScene().onPreCalc();
                    }
                    for (ExternalComponent externalComponent : Engine.this.externalComponents) {
                        externalComponent.onPrecalc();
                    }
                    logger.log(Level.INFO, "Preloading stopped");
                    Engine.this.resourcesLoaded.set(true);
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Engine failed during initialization", exception);
                    System.exit(-1);
                }
            }
        }, "PreLoader");
        thread.start();
    }

    public void record() {
        this.record = true;
    }

    static {
        GLProfile.initSingleton();
    }

    private class EngineGLEventListener
    implements GLEventListener {
        private static final float frameTime = 0.033333335f;
        private final float recordTime = 0.0f;
        private float sleepTime = 0.0f;

        private EngineGLEventListener() {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            Interval interval;
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            Engine.this.timeManager.frame();
            if (!Engine.this.resourcesLoaded.get()) {
                return;
            }
            if (!Engine.this.initializationPerformed.get()) {
                try {
                    logger.info("Initializing scenes");
                    Engine.this.initializationPerformed.set(true);
                    Engine.this.lifeCycleManager.onInit((GL)gL2);
                    for (TimelineScene object : Engine.this.timelineManager.getScenes()) {
                        logger.info(" init " + object.getScene());
                        object.getScene().onInit((GL)gL2);
                    }
                    for (ExternalComponent externalComponent : Engine.this.externalComponents) {
                        externalComponent.onSetTime(0.0f);
                        externalComponent.onPlay();
                    }
                    logger.info("Scenes initialized");
                    Engine.this.timeManager.reset();
                    Engine.this.timeManager.start();
                    return;
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Error during scene initialization: " + exception.getMessage(), exception);
                    System.exit(-1);
                }
            }
            float f = Engine.this.timeManager.getTime();
            float f2 = Engine.this.timeManager.getDeltaTime();
            if (Engine.this.cameraControl != null) {
                Engine.this.cameraControl.update(f2);
            }
            if ((interval = Engine.this.timelineManager.getInterval()).isAfter(f)) {
                if (Engine.this.debug && !Engine.this.timeManager.isPaused()) {
                    Engine.this.timeManager.pause();
                }
                if (!Engine.this.debug) {
                    Engine.this.animator.stop();
                    System.exit(0);
                }
            }
            List<TimelineScene> list = Engine.this.timelineManager.getScenes(f);
            if (Engine.this.debug && list.isEmpty()) {
                gL2.glClearColor(0.0f, 1.0f, 0.0f, 1.0f);
                gL2.glClear(16384);
            }
            if (!list.isEmpty()) {
                Engine.this.renderEngine.render(gL2, f, f2, list);
            }
            if (Engine.this.debug) {
                Engine.this.debugAvgFps = 0.99f * Engine.this.debugAvgFps + 0.01f * (1.0f / f2);
            }
            if (Engine.this.record) {
                Engine.this.recorder.record(gL2);
                if (f2 < 0.033333335f) {
                    this.sleepTime += 0.033333335f - f2;
                    if (this.sleepTime >= 0.01f) {
                        int n = (int)(this.sleepTime * 1000.0f);
                        try {
                            Thread.sleep(n);
                            this.sleepTime -= (float)n * 0.001f;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            for (TimelineScene timelineScene : Engine.this.timelineManager.getScenes()) {
                timelineScene.getScene().onDeinit(gL);
            }
            Engine.this.lifeCycleManager.onDeinit(gL);
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            try {
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                gL2.glViewport(0, 0, Engine.this.glcanvas.getWidth(), Engine.this.glcanvas.getHeight());
                Engine.this.renderEngine.configure(gL2, new Rectangle(0.0f, 0.0f, Engine.this.glcanvas.getWidth(), Engine.this.glcanvas.getHeight()));
                if (Engine.this.record) {
                    Engine.this.recorder = new Recorder(new File("recording"), Engine.this.glcanvas.getWidth(), Engine.this.glcanvas.getHeight());
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Error during startup: " + exception.getMessage(), exception);
                System.exit(-1);
            }
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glViewport(0, 0, Engine.this.glcanvas.getWidth(), Engine.this.glcanvas.getHeight());
            Engine.this.renderEngine.configure(gL2, new Rectangle(0.0f, 0.0f, Engine.this.glcanvas.getWidth(), Engine.this.glcanvas.getHeight()));
        }
    }
}

